#include <iostream>
#include <vector>
#include <set>
#include <queue>

using namespace std;

typedef long long llong;

const int MAXN = 1e7 + 10;

int n, q;
vector < int > adj[MAXN];
int p[MAXN];
int sz[MAXN];
int depth[MAXN];
llong dist[MAXN];

void read()
{
    cin >> n >> q;

    for(int i = 1; i < n; i++)
    {
        int u, v;
        cin >> u >> v;

        adj[u].push_back(v);
        adj[v].push_back(u);
    }
}

void dfs(int u, int par)
{
    p[u] = par;
    depth[u] = depth[par] + 1;
    sz[u] = 1;

    for(int v : adj[u])
    {
        if(v == par)
            continue;

        dfs(v, u);

        sz[u] += sz[v];
    }
}

void process_queries()
{
    llong ans = 0;

    for(int i = 1; i <= n; i++)
    {
        ans += 1LL * depth[i];
    }

    for(int i = 1; i <= q; i++)
    {
        int u, v;
        cin >> u >> v;

        if(u == p[v])
        {
            cout << ans << endl;
            continue;
        }

        ans -= sz[v];

        p[v] = u;

        cout << ans << endl;
    }
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);

    read();
    depth[0] = -1;
    dfs(1, 0);
    process_queries();

    return 0;
}