#include <iostream>
#include <vector>
#include <set>
#include <queue>

using namespace std;

typedef long long llong;

const int MAXN = 1e5 + 10;

int n, q;
vector < int > adj[MAXN];
int p[MAXN];
int dist[MAXN];

void read()
{
    cin >> n >> q;

    for(int i = 1; i < n; i++)
    {
        int u, v;
        cin >> u >> v;

        adj[u].push_back(v);
        adj[v].push_back(u);
    }
}

void bfs()
{
    for(int i = 1; i <= n; i++)
    {
        dist[i] = -1;
    }

    dist[1] = 0;

    queue < int > q;

    q.push(1);

    while(!q.empty())
    {
        int u = q.front();
        q.pop();

        for(int v : adj[u])
        {
            if(dist[v] != -1)
                continue;

            p[v] = u;
            dist[v] = dist[u] + 1;
            q.push(v);
        }
    }
}

void attach(int u, int v)
{
    while(v != u)
    {
        adj[u].push_back(v);
        adj[v].push_back(u);

        v = p[v];
    }
}

void process_queries()
{
    bfs();

    for(int i = 1; i <= q; i++)
    {
        int u, v;
        cin >> u >> v;

        attach(u, v);
        bfs();

        llong ans = 0;

        for(int j = 1; j <= n; j++)
        {
            ans += 1LL * dist[j];
        }

        cout << ans << endl;
    }
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);

    read();
    process_queries();

    return 0;
}