#include "oriand.h"

using namespace std;

typedef unsigned long long llong;

const int MAXN = 1e6 + 10;
const llong ANDD = (1LL << 63) - 1LL;
const int MAXK = 64;

int n, k;
llong a[MAXN];
int orp[MAXN];
int andp[MAXN];
int cnt[MAXK];

llong c;

void find_or()
{
    for(int bit = 0; bit < MAXK; bit++)
    {
        cnt[bit] = 0;
    }

    int right = 1;

    a[0] = 0;

    for(int bit = 0; bit < k; bit++)
    {
        if(a[1] & (1LL << bit))
            cnt[bit]++;
    }
    
    for(int left = 1; left <= n; left++)
    {
        int minb = n + 1;
        for(int bit = 0; bit < k; bit++)
        {
            if(a[left - 1] & (1LL << bit))
            {
                cnt[bit]--;
            }
            minb = min(minb, cnt[bit]);
        }

        while(right <= n)
        {
            if(minb > 0)
                break;

            right++;

            minb = n + 1;

            for(int bit = 0; bit < k; bit++)
            {
                if(a[right] & (1LL << bit))
                {
                    cnt[bit]++;
                }

                minb = min(minb, cnt[bit]);
            }
        }

        orp[left] = right;
    }
}

void find_and()
{
    
    for(int bit = 0; bit < MAXK; bit++)
    {
        cnt[bit] = 0;
    }

    int left = n;

    a[n + 1] = 0;

    for(int bit = 0; bit < k; bit++)
    {
        if(a[n] & (1LL << bit))
            cnt[bit]++;
    }
    
    for(int right = n; right >= 1; right--)
    {
        int maxb = 0;

        for(int bit = 0; bit < k; bit++)
        {
            if(a[right + 1] & (1LL << bit))
            {
                cnt[bit]--;
            }
                
            maxb = max(maxb, cnt[bit]);
        }

        while(1 <= left)
        {
            if(maxb < right - left + 1)
                break;

            left--;

            maxb = 0;

            for(int bit = 0; bit < k; bit++)
            {
                if(a[left] & (1LL << bit))
                {
                    cnt[bit]++;
                }

                maxb = max(maxb, cnt[bit]);
            }
        }

        andp[right] = left;
    }
}

int check(int left, int right)
{
    return orp[left] < andp[right];
}

llong solve()
{
    find_or();
    find_and();

    llong ans = 0;

    int right = 2;
    
    for(int left = 1; left <= n; left++)
    {
        while(right <= n)
        {
            if(check(left, right))
                break;

            right++;
        }

        if(left < right && check(left, right))
            ans = ans + 1LL * (n - right + 1);
    }

    return ans;
}

long long oriand(int N, int K, std::vector<long long> A)
{
    n = N;
    k = K;

    for(int i = 1; i <= n; i++)
    {
        a[i] = A[i - 1];
    }

    return solve();
}
