#include "oriand.h"

using namespace std;

typedef unsigned long long llong;

const int MAXN = 1e6 + 10;
const llong ANDD = (1LL << 63) - 1LL;

int n, k;
llong a[MAXN];

struct SegmentTreeOR
{
    llong tree[4 * MAXN];

    SegmentTreeOR(){};

    void build(int left, int right, int idx)
    {
        if(left == right)
        {
            tree[idx] = a[left];
            
            return;
        }

        int mid = left + (right - left) / 2;

        build(left, mid, 2 * idx);
        build(mid + 1, right, 2 * idx + 1);

        tree[idx] = tree[2 * idx] | tree[2 * idx + 1];
    }

    llong query(int left, int right, int idx, int qleft, int qright)
    {
        if(qright < left || right < qleft)
            return 0;

        if(qleft <= left && right <= qright)
            return tree[idx];

        int mid = left + (right - left) / 2;

        llong Lnode = query(left, mid, 2 * idx, qleft, qright);
        llong Rnode = query(mid + 1, right, 2 * idx + 1, qleft, qright);

        return Lnode | Rnode;
    }

    void build()
    {
        build(1, n, 1);
    }

    llong query(int left, int right)
    {
        return query(1, n, 1, left, right);
    }
};

struct SegmentTreeAND
{
    llong tree[4 * MAXN];

    SegmentTreeAND(){};

    void build(int left, int right, int idx)
    {
        if(left == right)
        {
            tree[idx] = a[left];
            return;
        }

        int mid = left + (right - left) / 2;

        build(left, mid, 2 * idx);
        build(mid + 1, right, 2 * idx + 1);

        tree[idx] = tree[2 * idx] & tree[2 * idx + 1];
    }

    llong query(int left, int right, int idx, int qleft, int qright)
    {
        if(qright < left || right < qleft)
            return ANDD;

        if(qleft <= left && right <= qright)
            return tree[idx];

        int mid = left + (right - left) / 2;

        llong Lnode = query(left, mid, 2 * idx, qleft, qright);
        llong Rnode = query(mid + 1, right, 2 * idx + 1, qleft, qright);

        return Lnode & Rnode;
    }

    void build()
    {
        build(1, n, 1);
    }

    llong query(int left, int right)
    {
        return query(1, n, 1, left, right);
    }
};

SegmentTreeAND stand;
SegmentTreeOR stor;

llong c;

int find_or(int pos)
{
    int left = pos - 1;
    int right = n + 1;
    int mid;

    while(right - left > 1)
    {
        mid = left + (right - left) / 2;

        if(stor.query(pos, mid) == c)
            right = mid;
        else
            left = mid;
    }

    return right;
}

int find_and(int pos)
{
    int left = 0;
    int right = pos + 1;
    int mid;

    while(right - left > 1)
    {
        mid = left + (right - left) / 2;

        if(stand.query(mid, pos) == 0)
            left = mid;
        else
            right = mid;
    }

    return left;
}

int check(int left, int right)
{
    return find_or(left) < find_and(right);
}

llong solve()
{
    stand.build();
    stor.build();

    c = (1LL << k) - 1;

    llong ans = 0;

    for(int i = 1; i <= n; i++)
    {
        for(int j = i + 1; j <= n; j++)
        {
            if(check(i, j))
                ans++;
        }
    }

    return ans;
}

long long oriand(int N, int K, std::vector<long long> A)
{
    n = N;
    k = K;

    for(int i = 1; i <= n; i++)
    {
        a[i] = A[i - 1];
    }

    return solve();
}
