#include "oriand.h"
#include <algorithm>
#include <iostream>
#include <vector>

const int MAXN = 1e6 + 10;

typedef unsigned long long ll;

int n, k;
ll a[MAXN];
ll prefix[MAXN];
ll suffix[MAXN];

ll targetOR;
ll targetAND;

ll ans = 0;

void count(int l, int r)
{
    prefix[l] = a[l];
    for(int i = l + 1 ; i <= r ; ++i)
    {
        prefix[i] = prefix[i - 1] | a[i];
    }

    suffix[r] = a[r];
    for(int i = r - 1 ; i >= l ; --i)
    {
        suffix[i] = suffix[i + 1] & a[i];
    }

    for(int split = l ; split < r ; ++split)
    {
        if((prefix[split] == targetOR) && (suffix[split + 1] == targetAND))
        {
            ans += 1;
            break;
        }
    }
}

/*
7 3
7 0 1 2 4 7 0
*/

long long oriand(int N, int K, std::vector<long long> A)
{
    n = N;
    k = K;

    for(int i = 0 ; i < N ; ++i)
    {
        a[i + 1] = A[i];
    }

    targetOR = (1 << K) - 1;
    targetAND = 0;
    

    for(int i = 1 ; i <= n ; ++i)
    {
        for(int j = i + 1 ; j <= n ; ++j)
        {
            count(i, j);
        }
    }

    return ans;
}