#include "oriand.h"
#include <algorithm>
#include <iostream>
#include <vector>

const int MAXN = 500 * 500 + 10;

int n, k;
long long a[MAXN];
long long suffixOR[MAXN];
long long prefixAND[MAXN];
bool answered[MAXN][MAXN];

int targetOR;
int targetAND;

long long ans = 0;

long long oriand(int N, int K, std::vector<long long> A)
{
    n = N;
    k = K;

    for(int i = 0 ; i < N ; ++i)
    {
        a[i + 1] = A[i];
    }

    targetOR = (1 << K) - 1;
    targetAND = 0;
    
    for(int mid = 1 ; mid < n ; ++mid)
    {
        std::vector<long long> left, right;

        suffixOR[mid] = a[mid];
        if(suffixOR[mid] == targetOR) left.push_back(mid);
        for(int i = mid - 1 ; i >= 1 ; --i)
        {
            suffixOR[i] = suffixOR[i + 1] | a[i];
            if(suffixOR[i] == targetOR) left.push_back(i);
        }

        prefixAND[mid + 1] = a[mid + 1];
        if(prefixAND[mid + 1] == targetAND) right.push_back(mid + 1);
        for(int i = mid + 2 ; i <= n ; ++i)
        {
            prefixAND[i] = prefixAND[i - 1] & a[i];
            if(prefixAND[i] == targetAND) right.push_back(i);
        }

        for(int x : left)
        {
            for(int y : right)
            {
                if(answered[x][y]) ans -= 1;
                answered[x][y] = 1;
            }
        }

        //std::cout << mid << " " << left.size() << " " << right.size() << "\n";
        ans += 1LL * left.size() * right.size();
    }

    return ans;
}