#include <algorithm>
#include <iostream>
#include <vector>
#include <random>
#include <cassert>

const int MAXN = 500 + 5;

std::mt19937 rng(1231205);

int n;

int numMatches(const std::vector<int>& perm);

std::vector<int> findPerm(int N)
{
    n = N;
    std::vector<int> perm(N, 0);
    std::iota(perm.begin(), perm.end(), 0);

    for(int i = 1 ; i < n ; ++i)
    {
        int current = numMatches(perm);
        if(current == n)
        {
            return perm;
        }

        if(current % 2 == 0)
        {
            break;
        }

        std::swap(perm[0], perm[i]);

        int next = numMatches(perm);
        if(next % 2 == 0)
        {
            break;
        }
        else
        {
            std::swap(perm[0], perm[i]);
        }
    }

    for(int i = 0 ; i < n ; ++i)
    {
        for(int j = 0 ; j < n ; ++j)
        {
            int current = numMatches(perm);

            if(current == n)
            {
                return perm;
            }

            std::swap(perm[i], perm[j]);

            int next = numMatches(perm);

            if(next - current != 2)
            {
                std::swap(perm[i], perm[j]);
            }
        }
    }

    return perm;
}