#include <algorithm>
#include <iostream>
#include <vector>
#include <random>
#include <cassert>

const int MAXN = 500 + 5;

std::mt19937 rng(1231205);

int n;

int numMatches(const std::vector<int>& perm);

std::vector<int> findPerm(int N)
{
    n = N;
    std::vector<int> perm(N, 0);
    std::iota(perm.begin(), perm.end(), 0);

    for(int i = 1 ; i < n ; ++i)
    {
        int before = numMatches(perm);
        if(before % 2 == 0)
        {
            break;
        }

        std::swap(perm[0], perm[i]);

        int after = numMatches(perm);
        if(after % 2 == 0)
        {
            break;
        }
        else
        {
            std::swap(perm[0], perm[i]);
        }
    }

    for(int i = 0 ; i < n ; ++i)
    {
        for(int j = 0 ; j < n ; ++j)
        {
            int before = numMatches(perm);

            std::swap(perm[i], perm[j]);

            int after = numMatches(perm);

            if(after - before != 2)
            {
                std::swap(perm[i], perm[j]);
            }
        }
    }

    return perm;
}