#include<iostream>
using namespace std;

const int MAX_N = 1e5 + 42;
const bool DEBUG = false;

struct Promotion{
    int p, c; // p becomes a direct parent of c
};

int n, q, disorder = 0;
int child_count[MAX_N], par[MAX_N]; // 1 indexed!!!!
Promotion proms[MAX_N];

void fast_io(){
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);
}

void input(){
    cin >> n >> q;
    par[1] = 1;
    for(int i = 1; i <= n; ++i){
        child_count[i] = 1;
        par[i] = i;
    }
    for(int i = 0; i < n - 1; ++i){
        int u, v;
        cin >> u >> v; // u is the parent of v
        par[v] = u;
        int H = v;
        while(H != par[H]){
            child_count[par[H]] += child_count[v];
            H = par[H];
        }
    }
    for(int i = 0; i < q; ++i){
        cin >> proms[i].p >> proms[i].c;
    }
}

int find_compression(int u, int until_node){
    if(u == par[u] or u == until_node) return u; // top manager
    int old_par = par[u];
    int parent_of_u = find_compression(par[u], until_node);
    if(old_par == until_node){ // manager below the top manager
        // the top manager does not receive a change in the child count
    }else{ // manager of u does receive a change in their child count
        int change = child_count[u];
        child_count[old_par] -= change;
        disorder -= change;
    }
    par[u] = parent_of_u;
    return par[u];
}

int find_children(int u, int cnt, int b){
    if(b) child_count[u]++;
    if(u == 1) return cnt;
    return find_children(par[u], cnt + 1, b);
}

int main(){
    fast_io();
    input();
    /*for(int i = 1; i <= n; ++i){
        disorder += find_children(i, 0, true);
    }*/
    for(int i = 2; i <= n; ++i){
        disorder += child_count[i];
    }
    if(DEBUG) {for(int i = 1; i <= n; ++i){ cout << child_count[i] << " "; } cout << endl;}
    if(DEBUG) cout << disorder << endl;
    for(int i = 0; i < q; ++i){
        find_compression(proms[i].c, proms[i].p);
        if(DEBUG) {for(int i = 1; i <= n; ++i){ cout << child_count[i] << " "; } cout << endl;}
        if(DEBUG) {for(int i = 1; i <= n; ++i){ cout << par[i] << " "; } cout << endl;}
        int real_disorder = 0;
        if(DEBUG) for(int i = 1; i <= n; ++i){
            real_disorder += find_children(i, 0, false);
        }
        if(DEBUG) cout << real_disorder << " vs " << disorder << endl;
        if(!DEBUG) cout << disorder << endl;
    }
    return 0;
}

// this is just union find
/*
int find_compression(int u, int until_node){
    if(u == par[u] or u == until_node) return u; // top manager
    int old_par = par[u];
    int parent_of_u = find_compression(par[u], until_node);
    if(old_par == until_node){ // manager below the top manager
        // the top manager does not receive a change in the child count
    }else{ // manager of u does receive a change in their child count
        int change = child_count[u];
        child_count[old_par] -= change;
        disorder -= change;
    }
    par[u] = parent_of_u;
    return par[u];
}

how does that differ from?

int find_compression(int u, int until_node){
    if(u == par[u] or u == until_node) return u; // top manager
    if(par[u] == until_node){ // manager below the top manager
        // the top manager does not receive a change in the child count
    }else{ // manager of u does receive a change in their child count
        int change = child_count[u];
        child_count[par[u]] -= change;
        disorder -= change;
    }
    int parent_of_u = find_compression(par[u], until_node);
    par[u] = parent_of_u;
    return par[u];
}

like lmao??


*/
