#include<iostream>
using namespace std;

const int MAX_N = 1e5 + 42;

struct Promotion{
    int p, c; // p becomes a direct parent of c
};

int n, q, disorder = 0;
int child_count[MAX_N], par[MAX_N]; // 1 indexed!!!!
Promotion proms[MAX_N];

void input(){
    cin >> n >> q;
    par[1] = 1;
    for(int i = 0; i < n - 1; ++i){
        int u, v;
        cin >> u >> v; // u is the parent of v
        par[v] = u;
        child_count[i + 1] = 0;
    }
    for(int i = 0; i < q; ++i){
        cin >> proms[i].p >> proms[i].c;
    }
}

void union_(int u, int v){ // u becomes parent of v
    par[v] = u;
}

int find_compression(int u, int until_node){
    if(u == until_node) return u; // top manager

    int parent_of_u = find_compression(par[u], until_node);

    if(par[u] == until_node){ // manager below the top manager
        // the top manager does not receive a change in the child count
    }else{ // manager of u does receive a change in their child count
        int change = child_count[u] + 1;
        child_count[parent_of_u] -= change;
        disorder -= change;
    }
    par[u] = parent_of_u;
    return par[u];
}

int find_children(int u, int cnt){
    child_count[u]++;
    if(u == 1) return cnt;
    return find_children(par[u], cnt + 1);
}

int main(){
    input();
    for(int i = 1; i <= n; ++i){
        disorder += find_children(i, 0);
    }
    for(int i = 0; i < q; ++i){
        find_compression(proms[i].c, proms[i].p);
    //for(int i = 1; i <= n; ++i){ cout << child_count[i] << " "; } cout << endl;
        /*disorder = 0;
        for(int i = 1; i <= n; ++i){
            disorder += find_children(i, 0);
        }*/
        cout << disorder << endl;
    }
    return 0;
}

// this is just union find
