#include<iostream>
using namespace std;

const int MAX_N = 1e5 + 42;

struct Promotion{
    int p, c; // p becomes a direct parent of c
};

int n, q, par[MAX_N]; // 1 indexed!!!!
Promotion proms[MAX_N];

void input(){
    cin >> n >> q;
    par[1] = 1;
    for(int i = 0; i < n - 1; ++i){
        int u, v;
        cin >> u >> v; // u is the parent of v
        par[v] = u;
    }
    for(int i = 0; i < q; ++i){
        cin >> proms[i].p >> proms[i].c;
    }
}

// u becomes the direct parent of v
void union_(int u, int v){
    par[v] = u;
}

int find_compression(int u, int until_node){
    //cout << "Find for " << u << " until " << until_node << endl;
    if(u == par[u] or u == until_node) return u;
    par[u] = find_compression(par[u], until_node);
    return par[u];
}

int find_hop_count(int u, int cnt){
    if(u == 1) return cnt;
    return find_hop_count(par[u], cnt + 1);
}

int main(){
    input();

        int disorder = 0;
        for(int i = 2; i <= n; ++i){
            disorder += find_hop_count(i, 0);
        }
    for(int i = 0; i < q; ++i){
        find_compression(proms[i].c, proms[i].p);
        union_(proms[i].p, proms[i].c);
        cout << 10 << endl;
    }
    return 0;
}
// this is just union find
