#include "oriand.h"

const int MAX_N = 1e6 + 42;

int fenwick_OR[MAX_N], fenwick_AND[MAX_N];

int query_OR(int i){
    int ans = 0;
    while(i > 1){
        ans |= fenwick_OR[i];
        i -= i & -i;
    }
    return ans;
}

void update_OR(int i, int val, int N){
    while(i <= N){
        fenwick_OR[i] |= val;
        i += (i & -i);
    }
}

void build_OR_fenwick(int N, std::vector<long long>& A){
    for(int i = 1; i <= N; ++i){
        fenwick_OR[i] = 0;
    }
    for(int i = 1; i <= N; ++i){
        update_OR(i, A[i - 1], N);
    }
}

long long OR(int l, int r, std::vector<long long>& A){
    long long ans = A[l];
    for(int i = l; i <= r; ++i){
        ans |= A[i];
    }
    //std::cout << ans << " VS " << (query_OR(r) | query_OR(l - 1)) << std::endl;
    return ans;
}

long long AND(int l, int r, std::vector<long long>& A){
    long long ans = A[l];
    for(int i = l; i <= r; ++i){
        ans &= A[i];
    }
    return ans;
}

long long oriand(int N, int K, std::vector<long long> A){
    build_OR_fenwick(N, A);
    //std::cout << "BUILT";
    long long ans = 0, big = (1 << K) - 1;
    for(int l = 0; l < N; ++l){
        for(int r = l + 1; r < N; ++r){
            for(int m = l; m < r; ++m){
                bool or_ = (OR(l, m, A) == big), and_ = (AND(m + 1, r, A) == 0);
                if(!and_) break;
                if(or_ && and_){
                    ans++;
                    break;
                }
            }
        }
    }
    return ans;
}
