#include<bits/stdc++.h>
using namespace std;
#define ll long long
#define endl "\n"
vector<int> parent;
vector<set<int>> children;
vector<pair<int,int>> queries;
vector<int> depth;
vector<int>children_count;

ll base_count = 0;
ll curr_count = 0;
int curr_children_count = 0;

void stdio()
{
    ios::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);
}
void tree_count(int curr = 1, int d = 0)
{
    curr_count += d;
    for(int c : children[curr])
    {
        tree_count(c, d + 1);
    }
}
void update_depth(int curr = 1, int d = 0)
{
    depth[curr] = d;
    for(int c : children[curr]) update_depth(c, d + 1);
}
int count_children(int curr = 1)
{
    int sum = 1;
    for(int c : children[curr]) sum += count_children(c);
    children_count[curr] = sum;
    return sum;
}
void update_tree(int p, int curr, int subtract = 0)
{
    if(parent[curr] == p) return;
    int old_parent = parent[curr];
    parent[curr] = p;
    children[p].insert(curr);

    curr_count += (depth[curr] - depth[p] - 1) * children_count[curr];
    children[old_parent].erase(curr);
    subtract += children_count[curr];
    children_count[old_parent] -= subtract;
    update_depth(curr, depth[p] + 1);

    update_tree(p, old_parent, subtract);
}
void update_count()
{
    tree_count();
}
void make_query(int p, int c)
{
    curr_count = 0;
    update_tree(p, c);
    base_count -= curr_count;
    cout << base_count<< endl;

}
void solve()
{
    tree_count();
    update_depth();
    count_children();
    base_count = curr_count;
    for(pair<int,int> curr : queries)
    {
        make_query(curr.first, curr.second);
    }
}
int main()
{
    int n, q;
    cin >> n >> q;
    parent.resize(n + 1);
    children.resize(n + 1);
    depth.resize(n + 1);
    children_count.resize(n + 1);
    queries.resize(q);
    for(int i = 0; i < n - 1; i ++)
    {
        int a, b;
        cin >> a >> b;
        parent[b] = a;
        children[a].insert(b);
    }
    for(int i = 0; i < q; i ++)
    {
        int c, p;
        cin >> p >> c;
        queries[i] = {p, c};
    }
    solve();
    return 0;
}

