#include<bits/stdc++.h>
using namespace std;
#define ll long long
#define endl "\n"
vector<int> parent;
vector<set<int>> children;
vector<pair<int,int>> queries;
ll base_count = 0;
ll curr_count = 0;
void stdio()
{
    ios::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);
}
void tree_count(int curr = 1, int depth = 0)
{
    curr_count += depth;
    for(int c : children[curr])
    {
        tree_count(c, depth + 1);
    }
}
void update_tree(int p, int curr)
{
    if(parent[curr] == p) return;
    int old_parent = parent[curr];
    parent[curr] = p;
    children[p].insert(curr);
    children[old_parent].erase(curr);
    update_tree(p, old_parent);
}
void update_count()
{
    curr_count = 0;
    tree_count();
}
void make_query(int p, int c)
{
    update_tree(p, c);
    update_count();
    cout << curr_count << endl;
}
void solve()
{
    tree_count();
    base_count = curr_count;
    for(pair<int,int> curr : queries)
    {
        make_query(curr.first, curr.second);
    }
}
int main()
{
    int n, q;
    cin >> n >> q;
    parent.resize(n + 1);
    children.resize(n + 1);
    queries.resize(q);
    for(int i = 0; i < n - 1; i ++)
    {
        int a, b;
        cin >> a >> b;
        parent[b] = a;
        children[a].insert(b);
    }
    for(int i = 0; i < q; i ++)
    {
        int c, p;
        cin >> p >> c;
        queries[i] = {p, c};
    }
    solve();
    return 0;
}

