#include <bits/stdc++.h>
#define int long long

using namespace std;

const int MAXN = 1e5 + 7;

struct Edge
{
    int to, id;
};

struct Node
{
    int p, dep;
};

int n, q;
vector<Edge> v[MAXN];
Node node[MAXN];
bool Del[10 * MAXN];
int ans, br;
vector<pair<int, int> > qur;

void FastIO()
{
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    cout.tie();
}

void Read()
{
    cin >> n >> q;
    int x, y;
    for(int i = 1; i < n; i++)
    {
        cin >> x >> y;
        v[x].push_back({y, i});
        v[y].push_back({x, i});
    }
    for(int i = 1; i <= q; i++)
    {
        cin >> x >> y;
        qur.push_back({x, y});
    }
}

int noGo;

void dfs(int x)
{
    ans -= node[x].dep;
    node[x].dep = node[node[x].p].dep + 1;
    ans += node[x].dep;
    for(auto [to, id]:v[x])
    {
        if(to == node[x].p || Del[id])
            continue;
        if(to == noGo)
        {
            Del[id] = true;
            continue;
        }
        node[to].p = x;
        dfs(to);
    }
}

void Change(int x, int newP)
{
    if(node[x].p == newP)
        return;
    noGo = node[x].p;
    node[x].p = newP;
    v[x].push_back({newP, br});
    v[newP].push_back({x, br});
    br++;
    dfs(x);
    Change(noGo, newP);
}

void Solve()
{
    node[0].dep = -1;
    dfs(1);
    br = n;
    for(auto [newP, x]:qur)
    {
        Change(x, newP);
        cout << ans << '\n';
    }
}

signed main()
{

    FastIO();
    Read();
    Solve();
    return 0;
}
