# include <iostream>
# include <vector>
# include <algorithm>
using namespace std;

const int MAX=1e5+11;

int n,q;
vector<int> adj[MAX];

long long ans=0;
int sz[MAX];
int up[MAX];

void dfs_init(int curr, int par)
{
    sz[curr]=1;
    for(int nxt: adj[curr])
    {
        if(nxt==par) continue;

        up[nxt]=curr;
        dfs_init(nxt,curr);
        sz[curr]+=sz[nxt];
    }

    ans+=sz[curr];
}

int main()
{
    ios_base::sync_with_stdio(0);
    cin.tie(0);cout.tie(0);

    cin>>n>>q;
    for(int i=1;i<n;i++)
    {
        int u,v;
        cin>>u>>v;
        adj[u].push_back(v);
        adj[v].push_back(u);
    }

    dfs_init(1,0);
    ans-=n;

    while(q--)
    {
        int u,par;
        cin>>par>>u;

        vector<int> vert;
        while(u!=par)
        {
            vert.push_back(u);
            u=up[u];
        }

        int S=vert.size(),rem=0;
        for(int i=0;i<S;i++)
        {
            up[vert[i]]=par;
            if(i==0) rem+=sz[vert[i]];
            else
            {
                sz[vert[i]]-=rem;
                ans-=rem;
                rem++;
            }
        }

        cout<<ans<<"\n";
    }

    return 0;
}

/*
9 4
1 2
1 3
3 4
3 5
4 6
4 7
5 8
8 9
1 3
1 4
1 8
1 7
*/
