# include <iostream>
# include <vector>
using namespace std;
# include "oriand.h"
//# include "grader.cpp"

const int MAX=1e6+11,LOG=20,INF=1e9;

int n,k;
long long a[MAX];
long long st1[MAX][LOG];
long long st2[MAX][LOG];

void sparse_table()
{
    for(int i=1;i<=n;i++)
    {
        st1[i][0]=a[i];
        st2[i][0]=a[i];
    }

    for(int j=1;j<LOG;j++)
    {
        for(int i=1;i<=n;i++)
        {
            if(i+(1<<j)-1>n) break;
            st1[i][j]=(st1[i][j-1]|st1[i+(1<<(j-1))][j-1]);
            st2[i][j]=(st2[i][j-1]&st2[i+(1<<(j-1))][j-1]);
        }
    }
}

long long queryOr(int l, int r)
{
    int j=31-__builtin_clz(r-l+1);
    return (st1[l][j]|st1[r-(1<<j)+1][j]);
}

long long queryAnd(int l, int r)
{
    int j=31-__builtin_clz(r-l+1);
    return (st2[l][j]&st2[r-(1<<j)+1][j]);
}

int b[MAX];
int c[MAX];

long long oriand(int N, int K, std::vector<long long> A)
{
    n=N;k=K;
    for(int i=0;i<n;i++) a[i+1]=A[i];
    sparse_table();

    long long curr=0,OR=(1<<K)-1;
    int ptr=1;
    for(int i=1;i<=n;i++)
    {
        if(ptr<i)
        {
            ptr=i;
            curr=a[i];
        }
        else curr=queryOr(i,ptr);

        while(ptr+1<=n and curr!=OR)
        {
            ptr++;
            curr|=a[ptr];
        }
        if(curr==OR) b[i]=ptr;
        else b[i]=INF;
    }
    ptr=1;
    curr=0;
    for(int i=1;i<=n;i++)
    {
        if(ptr<i)
        {
            ptr=i;
            curr=a[i];
        }
        else curr=queryAnd(i,ptr);
        while(ptr+1<=n and curr!=0)
        {
            ptr++;
            curr&=a[ptr];
        }
        if(curr==0) c[i]=ptr;
        else c[i]=INF;
    }

    long long ans=0;
    for(int i=1;i<=n;i++)
    {
        int r=b[i]+1;
        if(r>n) continue;
        r=c[r];
        if(r>n) continue;
        ans+=n-r+1;
    }

    return ans;
}
