# include <iostream>
# include <vector>
# include <algorithm>
# include <random>
# include <queue>
using namespace std;
# include "mummy.h"
//# include "grader.cpp"

const int INF=1e9;

struct edge
{
    int u,v,flow=0,cap=0;
    edge(int _u, int _v, int _cap)
    {
        u=_u;
        v=_v;
        cap=_cap;
    }
};

struct Dinic
{
    int source,sink,ct;
    vector<vector<int>> adj;
    vector<edge> edges;
    vector<int> level,ptr;

    void init(int N)
    {
        ct=0;
        adj.resize(N);
        level.resize(N);
        ptr.resize(N);
    }

    void add_edge(int u, int v, int cap=1)
    {
        cout<<"->"<<u<<" "<<v<<"\n";
        edges.push_back({u,v,cap});
        adj[u].push_back(ct);
        edges.push_back({v,u,0});
        adj[v].push_back(ct+1);
        ct+=2;
    }

    void bfs()
    {
        for(int i=0;i<=sink;i++) level[i]=-1;

        level[source]=1;
        queue<int> q;
        q.push(source);
        while(q.size()>0)
        {
            int curr=q.front();
            q.pop();

            for(int edge_id: adj[curr])
            {
                int v=edges[edge_id].v;
                if(edges[edge_id].flow==edges[edge_id].cap) continue;
                if(level[v]==-1)
                {
                    level[v]=level[curr]+1;
                    q.push(v);
                }
            }
        }
    }

    int dfs(int curr, int flow)
    {
        if(curr==sink) return flow;
        if(flow==0) return 0;

        for(int& cid=ptr[curr];cid<(int)adj[curr].size();cid++)
        {
            int edge_id=adj[curr][cid];
            int v=edges[edge_id].v;
            if(level[curr]+1!=level[v]) continue;

            int flow2=min(flow,dfs(v,edges[edge_id].cap-edges[edge_id].flow));
            if(flow2!=0)
            {
                edges[edge_id].flow+=flow2;
                edges[edge_id^1].flow-=flow2;
                return flow2;
            }
        }

        return 0;
    }

    int max_flow()
    {
        int ans=0;
        while(true)
        {
            bfs();
            if(level[sink]==-1) break;

            for(int i=0;i<=sink;i++) ptr[i]=0;
            while(true)
            {
                int flow=dfs(source,INF);
                if(flow==0) break;
                else ans+=flow;
            }
        }

        return ans;
    }
};

std::vector<int> findPerm(int n)
{
    vector<int> ans(n),in(n*2+11,1);
    for(int i=0;i<n;i++)
    {
        ans[i]=i;
    }
    int now=numMatches(ans);
    if(now==n) return ans;

    Dinic dinic;
    dinic.init(n*2+11);
    int source=n*2,sink=n*2+1;
    dinic.source=source;dinic.sink=sink;

    for(int i=0;i<n;i++)
    {
        for(int j=0;j<n;j++)
        {
            if(i==j) continue;

            vector<int> v=ans;
            swap(v[i],v[j]);
            int resp=numMatches(v)-now;
            if(resp==2)
            {
                //dinic.add_edge(i,n+j);
                //dinic.add_edge(j,n+i);
                ans[i]=j;in[i]=0;in[n+i]=0;
                ans[j]=i;in[n+j]=0;in[n+j]=0;
            }
            /*else if(resp==-2)
            {
                //dinic.add_edge(i,n+i);
                //dinic.add_edge(j,n+j);
                ans[i]=i;in[i]=0;in[n+i]=0;
                ans[j]=j;in[j]=0;in[n+j]=0;
            }
            */
            else if(resp==1)
            {
                dinic.add_edge(i,n+j);
                dinic.add_edge(j,n+i);
            }
            /*else if(resp==-1)
            {
                dinic.add_edge(i,n+i);
                dinic.add_edge(j,n+j);
            }
            */
        }
    }
    for(int i=0;i<n;i++)
    {
        if(in[i]) dinic.add_edge(source,i);
        if(in[n+i]) dinic.add_edge(n+i,sink);
    }

    int mx=dinic.max_flow();
    //cout<<mx<<endl;
    for(edge e: dinic.edges)
    {
        int u=e.u,v=e.v;
        if(u==source or v==source or u==sink or v==sink) continue;
        if(u>=0 and v>=n and e.flow==1 and e.cap==1)
        {
            ans[u]=v-n;
            //cout<<u<<"->"<<v-n<<"\n";
        }
    }

    return ans;
}

/*
4
1
1 3 2 0
*/



/*
5
1
3 0 4 2 1
*/

