#include <bits/stdc++.h>
using namespace std;

const int MAXN = 1e5+5;

vector<vector<int>> adj(MAXN);
vector<int> depth(MAXN, 0);
vector<int> children(MAXN, 0);
vector<int> parent(MAXN, -1);
int total = 0;

int dfs(int u, int par) {
    depth[u] = 1 + depth[par];
    parent[u] = par;
    int child = 1;
    for (auto v : adj[u]) {
        child += dfs(v, u);
    }

    children[u] += child;
    total += depth[u];
    return child;
}

int main() {
    int n, q;
    cin >> n >> q;
    for (int i = 0; i < n - 1; i++) {
        int u, v;
        cin >> u >> v;
        u--; v--;
        adj[u].push_back({ v });
    }
    dfs(0, 0);
    total -= (n);

    cout << total << endl;


    while (q--) {
        int p, c;
        cin >> p >> c;
        p--; c--;
        //cout << "p" << p << " " << c << endl;
        int x = abs(depth[p] - depth[c]) - 1;
        //cout << depth[p] << " " << depth[c] << endl;
        int v = c;
        while (v != p) {
            total -= depth[v] - (abs(depth[p] - depth[0]) - 1);
            v = parent[v];
        }
        cout << total - (x * children[c]) << endl;

    }

}
