#include <bits/stdc++.h>
using namespace std;

const int MAXN = 1e5+5;
int total = 0;
vector<vector<int>> adj(MAXN);

struct DSU {
    vector<int> sz;
    vector<int> par;
    int n;
    void init(int _n) {
        n = _n;
        sz.resize(n);
        par.resize(n);
        for (int i = 0; i < n; i++) {
            make_set(i);
        }
    }

    void make_set(int v) {
        par[v] = v;
        sz[v] = 0;
    }

    int find_set(int v) {
        if (v == par[v])
            return v;
        return par[v] = find_set(par[v]);
    }

    void unite_sets(int a, int b) {
        a = find_set(a);
        b = find_set(b);
        if (a != b) {
            if (sz[a] < sz[b])
                swap(a, b);

            par[b] = a;
            sz[b] = sz[a] + 1;
            total += sz[b];
        }
    }
};

DSU dsu;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);
    int N, Q; // N - broi sluj, Q - broi povisheniq
    cin >> N >> Q;
    for (int i = 0; i < N - 1; i++) {
        int u, v;
        cin >> u >> v;
        u--; v--;
        adj[v].push_back({ v });
    }

    dsu.init(N - 1);

    for (int i = 0; i < Q; i++) {
        int u, v;
        cin >> u >> v;
        u--; v--;
        dsu.unite_sets(u, v);
    }

    for (int i = 0; i < N - 1; i++) {
        for (auto v : adj[i]) {
            if (dsu.par[v] != v)
                continue;

            dsu.unite_sets(i, v);
        }
    }

    cout << total - N + 1 << endl;
}
