/*
9 4
1 2
1 3
3 4
3 5
4 6
4 7
5 8
8 9
1 3
1 4
1 8
1 7
*/


#include<bits/stdc++.h>

using namespace std;

uint64_t N, Q;

struct employee_t {
    uint64_t n;
    employee_t* manager;
    unordered_set<employee_t*> managing;
};

unordered_map<uint64_t, employee_t*> employees;

void register_employee(uint64_t u, uint64_t v) {
    employee_t* w1;
    employee_t* w2;
    if(employees.find(u) == employees.end()){
        w1 = new employee_t;
        w1->n = u;
        employees.insert({u, w1});
    }
    else{
        w1 = employees[u];
    }
    if(employees.find(v) == employees.end()){
        w2 = new employee_t;
        w2->n = v;
        employees.insert({v, w2});
    }
    else{
        w2 = employees[v];
    }
    w1->managing.insert(w2);
    w2->manager = w1;
}

void change_tree(employee_t* cur_employee, employee_t* prev_employee, employee_t* new_manager){
/*
    cout << " Current employee: " << cur_employee->n + 1 << "\n";
    if(prev_employee != nullptr){
        cout << "Previous employee: " << prev_employee->n + 1 << "\n";
    }
    cout << "    New Manager: " << new_manager->n + 1<< "\n";
*/
    if(cur_employee->manager != new_manager){
        change_tree(cur_employee->manager, cur_employee, new_manager);
        cur_employee->manager = new_manager;
        new_manager->managing.insert(cur_employee);
    }
    cur_employee->managing.erase(prev_employee);
    return;
}

uint64_t communic_level_iter(){
    uint64_t sum = 0;
    unordered_set<employee_t*> bfs = {employees[0]};
    for(uint64_t depth = 1; !bfs.empty(); depth++){
        unordered_set<employee_t*> new_bfs;
        for(const auto& e : bfs){
            sum += (e->managing.size()) * depth;
            new_bfs.insert(e->managing.begin(), e->managing.end());
        }
        bfs.clear();
        bfs = std::move(new_bfs);
    }
    return sum;
}


uint64_t communic_level_rec (employee_t* cur_employee, uint64_t depth){
    uint64_t sum = depth;
    for(const auto& m : cur_employee->managing){
        sum += communic_level_rec(m, depth + 1);
    }
    return sum;
}


void print_tree(){
    for (const auto& e : employees){
        cout << e.second->n + 1<< " : ";
        for(const auto& m : e.second->managing){
            cout << m->n + 1<< " ";
        }
        cout << "\n";
    }
    return;
}

int main() {
    ios::sync_with_stdio(false);
    cout.tie(nullptr);
    cin.tie(nullptr);
    cin >> N >> Q;
    for(size_t i = 0; i < N - 1; i++) {
        uint64_t u, v;
        cin >> u >> v;
        register_employee(u - 1, v - 1);
    }
    for(size_t i = 0; i < Q; i++) {
        uint64_t p, c;
        cin >> p >> c;
        change_tree(employees[c - 1], nullptr, employees[p - 1]);
        cout << communic_level_rec (employees[0], 0) << "\n";
        //cout << communic_level_iter() << "\n";
        //print_tree();
    }

    return 0;
}
