/*
9 4
1 2
1 3
3 4
3 5
4 6
4 7
5 8
8 9
1 3
1 4
1 8
1 7
*/


#include<bits/stdc++.h>

using namespace std;

uint64_t N, Q;

struct worker{
    uint64_t n;
    worker* manager;
    unordered_set<worker*> managing;
};

unordered_map<uint64_t, worker*> workers;

void regist_node(uint64_t u, uint64_t v) {
    worker* w1;
    worker* w2;
    if(workers.find(u) == workers.end()){
        w1 = new worker;
        w1->n = u;
        workers.insert({u, w1});
    }
    else{
        w1 = workers[u];
    }
    if(workers.find(v) == workers.end()){
        w2 = new worker;
        w2->n = v;
        workers.insert({v, w2});
    }
    else{
        w2 = workers[v];
    }
    w1->managing.insert(w2);
    w2->manager = w1;
}

void change_tree(worker* cur_worker, worker* prev_worker, worker* new_manager){
/*
    cout << " Current Worker: " << cur_worker->n + 1 << "\n";
    if(prev_worker != nullptr){
        cout << "Previous Worker: " << prev_worker->n + 1 << "\n";
    }
    cout << "    New Manager: " << new_manager->n + 1<< "\n";
*/
    if(cur_worker->manager != new_manager){
        change_tree(cur_worker->manager, cur_worker, new_manager);
        cur_worker->manager = new_manager;
        new_manager->managing.insert(cur_worker);
    }
    cur_worker->managing.erase(prev_worker);
    return;
}

uint64_t communic_level(worker* cur_worker, uint64_t depth){
    uint64_t sum = depth;
    for(const auto& m : cur_worker->managing){
        sum += communic_level(m, depth + 1);
    }
    return sum;
}

void print_tree(){
    for (const auto& w : workers){
        cout << w.second->n + 1<< " : ";
        for(const auto& m : w.second->managing){
            cout << m->n + 1<< " ";
        }
        cout << "\n";
    }
    return;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    cin >> N >> Q;
    for(size_t i = 0; i < N - 1; i++) {
        uint64_t u, v;
        cin >> u >> v;
        regist_node(u - 1, v - 1);
    }
    for(size_t i = 0; i < Q; i++) {
        uint64_t p, c;
        cin >> p >> c;
        change_tree(workers[c - 1], nullptr, workers[p - 1]);
        cout << communic_level(workers[0], 0) << "\n";
        //print_tree();
    }

    return 0;
}
