#include <iostream>
#include <filesystem>
#include <fstream>
#include <set>
#include <map>
#include <string>
#include <stack>
#include <sstream>
#include <sys/stat.h>
#include <sys/types.h>
#include "test_utils.h"

const std::string TESTS_DIR = "../tests";
const std::string TASK_NAME = "oriand";
const std::vector<int> GROUPS = {1, 140};

long long TARGET_OR;

long long op(long long a, long long b, long long target) {
    if (target == 0) return a&b;
    return a|b;
}

std::vector<int> calc(std::vector<long long>& v, long long target) {
    std::vector<int> ans(v.size());

    int r = -1;
    std::stack<long long> st;
    st.push(TARGET_OR-target);
    long long curr = TARGET_OR-target;

    //std::cout << "calc..." << target << v.size() << std::endl;
    for (int i = 0; i < v.size(); i++) {
        while (r < (int) v.size() && op(st.top(), curr, target) != target) {
            ++r;
            if (r < (int) v.size()) curr = op(curr, v[r], target);
        }
        //std::cout << i << " " << r << " " << curr << std::endl;
        if (st.size() == 1 && r < v.size()) {
            curr = TARGET_OR-target;
            for (int j = r; j >= i; j--) {
                st.push(op(st.top(),v[j],target));
            }
        }

        ans[i] = r;
        if (r < v.size()) st.pop();
    }
    //std::cout << "calc...end" << std::endl;
    return ans;
}

std::vector<std::map<std::string, GroupLimit>> groupLimits = {
    { { "N", {0, 0} } }, // sample

    /// group0
    { { "N", {6, 6} } }, // example
    { { "N", {7, 7} } }, // example
    { { "N", {7, 7} } }, // example

    /// group1
    { { "N", {30, 100 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {30, 100 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {100, 100 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {100, 100 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {100, 100 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {100, 100 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {100, 100 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {100, 100 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {100, 100 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {100, 100 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {100, 100 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {100, 100 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {100, 100 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {100, 100 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {100, 100 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {100, 100 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {100, 100 } }, { "K", {1, (1Ull<<63)-1} } },

    /// group2
    { { "N", {300, 500 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {300, 500 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {300, 500 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {300, 500 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {300, 500 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {500, 500 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {500, 500 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {500, 500 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {500, 500 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {500, 500 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {500, 500 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {500, 500 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {500, 500 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {500, 500 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {500, 500 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {500, 500 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {500, 500 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {500, 500 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {500, 500 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {500, 500 } }, { "K", {1, (1Ull<<63)-1} } },

    /// group3
    { { "N", {10000, 10000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {10000, 10000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {10000, 10000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {10000, 10000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {10000, 10000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {10000, 10000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {10000, 10000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {10000, 10000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {10000, 10000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {10000, 10000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {10000, 10000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {10000, 10000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {10000, 10000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {10000, 10000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {10000, 10000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {10000, 10000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {10000, 10000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {10000, 10000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {10000, 10000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {10000, 10000 } }, { "K", {1, (1Ull<<63)-1} } },

    /// group4
    { { "N", {90000, 90000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {90000, 90000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {89999, 89999 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {90000, 90000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {90000, 90000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {90000, 90000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {90000, 90000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {90000, 90000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {89999, 89999 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {90000, 90000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {90000, 90000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {90000, 90000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {90000, 90000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {90000, 90000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {90000, 90000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {90000, 90000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {90000, 90000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {90000, 90000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {90000, 90000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {90000, 90000 } }, { "K", {1, (1Ull<<63)-1} } },

    /// group5
    { { "N", {3000, 90000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {3000, 90000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {3000, 90000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {3000, 90000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {3000, 90000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {90000, 90000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {90000, 90000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {90000, 90000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {90000, 90000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {90000, 90000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {90000, 90000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {90000, 90000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {90000, 90000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {90000, 90000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {90000, 90000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {90000, 90000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {90000, 90000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {90000, 90000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {90000, 90000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {90000, 90000 } }, { "K", {1, (1Ull<<63)-1} } },

    /// group6
    { { "N", {100000, 250000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {100000, 250000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {100000, 250000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {250000, 250000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {250000, 250000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {250000, 250000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {250000, 250000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {250000, 250000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {250000, 250000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {250000, 250000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {250000, 250000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {250000, 250000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {250000, 250000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {250000, 250000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {250000, 250000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {250000, 250000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {250000, 250000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {250000, 250000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {250000, 250000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {250000, 250000 } }, { "K", {1, (1Ull<<63)-1} } },

    /// group7
    { { "N", {600000, 600000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {700000, 700000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {800000, 800000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {900000, 900000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {900000, 900000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {1000000, 1000000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {1000000, 1000000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {1000000, 1000000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {1000000, 1000000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {1000000, 1000000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {1000000, 1000000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {1000000, 1000000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {1000000, 1000000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {1000000, 1000000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {1000000, 1000000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {1000000, 1000000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {1000000, 1000000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {1000000, 1000000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {1000000, 1000000 } }, { "K", {1, (1Ull<<63)-1} } },
    { { "N", {1000000, 1000000 } }, { "K", {1, (1Ull<<63)-1} } }
};

std::string join(const std::vector<long long>& v, const std::string& sep = " ") {
    std::ostringstream out;
    for (size_t i = 0; i < v.size(); i++) {
        if (i > 0) out << sep;
        out << v[i];
    }
    return out.str();
}

void validate(int testNumber, int n, int k, std::vector<long long> v) {
    assert(1 <= n);
    if (testNumber <= 20) assert(n <= 100);
    else if (testNumber <= 40) assert(n <= 500);
    else if (testNumber <= 60) assert(n <= 10000);
    else if (testNumber <= 80) assert(n <= 90000);
    else if (testNumber <= 100) assert(n <= 90000);
    else if (testNumber <= 120) assert(n <= 250000);
    else assert(n <= 1000000);

    assert(1 <= k && k <= 63);
    if (61 <= testNumber && testNumber <= 80) assert(k == 1);
    long long maxA = (1ULL<<k)-1;

    assert(v.size() == n);
    for (long long x: v) assert(0 <= x && x <= maxA);
}

std::vector<std::string> generateTest(int testNumber, int attempt) {
    std::cout << "generating test: " << testNumber << std::endl;

    int seed = generateSeed({attempt, testNumber, 6});
    RandomHelper random(seed);

    GroupLimit nlimit = groupLimits[testNumber]["N"];
    GroupLimit klimit = groupLimits[testNumber]["K"];

    /**tests
    1-3 examples
    4-10 n, k<=10
    11-20 n <= 100
    21-30 n <= 1000
    31-40 k = 1, n <= 10^5
    41-50 n <= 10^4
    51-60 n <= 10^5
    61-70 n <= 3.10^5
    71-80 n <= 10^6
    */
    int k = 63;
    if (testNumber == 1) k = 1;
    else if (testNumber <= 3) k = 3;
    else if (testNumber <= 10) k = random.inRange(2, 10);
    else if (61 <= testNumber && testNumber <= 80) k = 1;
    else if (testNumber%4 == 1) k = random.inRange(2, 60);
    TARGET_OR = (1ULL<<k)-1;

    int n = random.inRange(nlimit.minN, nlimit.maxN);
    std::vector<long long> v(n);
    for (int i = 0; i < n; i++) {
        v[i] = random.inRange(0, TARGET_OR);
    }

    bool bigRanges = false;
    if (testNumber > 3 && testNumber%2 == 0) bigRanges = true;

    if (bigRanges) {
        int bigIntervals  = random.inRange(1, std::min(60, n/10));
        bigIntervals = std::min(bigIntervals, k-1);
        if (61 <= testNumber &&  testNumber <= 80) bigIntervals = 1;
        for (int i = 0; i < bigIntervals; i++) {
            int left = random.inRange(1, n/3);
            int right = random.inRange(left+n/2, n);
            //std::cout<<"range: " << left << " " << right << std::endl;
            long long bit = (1ULL << i);
            for (int j = left; j < right; j++) {
                if (61 <= testNumber && testNumber <= 80) v[j] = 0;
                else if ((v[j]&bit) != 0) v[j] -= bit;
            }
            if (61 <= testNumber && testNumber <= 80) v[right] = TARGET_OR;
            else v[right] |= bit;
        }
    }

    //std::cout << "here1" << std::endl;


    if (bigRanges) {
        int bigIntervals  = random.inRange(1, std::min(60, n/10));
        if (61 <= testNumber && testNumber <= 80) bigIntervals = 1;
        for (int i = 0; i < bigIntervals; i++) {
            int left = random.inRange(1, n/3);
            int right = random.inRange(left+n/2, n);
            long long bit = (1ULL << i);
            for (int j = left; j < right; j++) {
                if (61 <= testNumber && testNumber <= 80) v[j] = TARGET_OR;
                else if ((v[j]&bit) == 0) v[j] += bit;
            }
            if (61 <= testNumber && testNumber <= 80) v[right] = 0;
            else v[right] &= bit;
        }
    }

    //std::cout << "here2" << std::endl;
    //std::cout << "here2: " << n << " " << k << " " << TARGET_OR << std::endl;

    auto ansOr = calc(v, TARGET_OR);
    //std::cout << "here3" << std::endl;

    long long sumOr = 0;
    for (int i = 0; i < ansOr.size(); i++) {
        sumOr += ansOr[i]-i+1;
    }
    std::cout << "ansOR: " << sumOr << std::endl;
    auto ansAnd = calc(v, 0);
    long long sumAnd = 0;
    for (int i = 0; i < ansAnd.size(); i++) {
        sumAnd += ansAnd[i]-i+1;
    }
    std::cout << "ansAnd: " << sumAnd << std::endl;

    if (testNumber == 1) {
        n = 6;
        k = 1;
        v = {1, 0, 0, 0, 1, 0};
    }
    if (testNumber == 2) {
        n = 7;
        k = 3;
        v = {7, 0, 1, 2, 4, 7, 0};
    }
    if (testNumber == 3) {
        n = 7;
        k = 3;
        v = {7, 6, 5, 4, 3, 2, 1};
    }

    if (testNumber%20 == 9) {
        for (int i = 0; i < n; i++) v[i]=0;
    }
    if (testNumber%20 == 10) {
        for (int i = 0; i < n; i++) v[i]=1;
    }
    if (testNumber%20 == 11) {
        for (int i = 0; i < n; i++) v[i]=TARGET_OR;
        v[n-1] = 0;
    }
    if (testNumber%20 == 12) {
        for (int i = 0; i < n; i++) v[i]=TARGET_OR;
        v[0] = 0;
    }
    if (testNumber%20 == 13) {
        for (int i = 0; i < n; i++) v[i]=0;
        v[n-2] = TARGET_OR;
    }
    if (testNumber%20 == 14) {
        for (int i = 0; i < n; i++) v[i]=1;
        v[1] = 0;
    }
    if (testNumber%20 == 15) {
        for (int i = 0; i < n; i++) {
            if (i < n/2) v[i] = 0;
            else v[i] = TARGET_OR;
        }
        v[n-1] = 0;
    }
    if (testNumber%20 == 16) {
        for (int i = 0; i < n; i++) {
            if (i < n/2) v[i] = 0;
            else v[i] = TARGET_OR;
        }
        v[0] = 1;
    }

    validate(testNumber, n, k, v);

    return {join({n, k}), join(v)};
}

void print(const std::vector<std::string>& v, int testNumber) {
    MKDIR(TESTS_DIR.c_str());
    std::string filename = generateFilename(TASK_NAME, testNumber, 3);
    std::ofstream outFile(TESTS_DIR + "/" + filename);

    for (const std::string& s: v) {
        outFile << s << '\n';
    }
    std::cout << v[0] << '\n';
    outFile.close();
}

int main(int argc, char *argv[]) {
    assert(std::accumulate(GROUPS.begin(), GROUPS.end(), 0) == groupLimits.size());

    std::set<size_t> hashes;
    for (int i = 1; i < GROUPS.size(); i++) {
        for (int j = 1; j <= GROUPS[i]; j++) {
            int attempt = 1;
            std::vector<std::string> v = generateTest(hashes.size()+1, attempt++);
            size_t h = hash_vector_of_strings(v);

            std::cout << "hash is: " << h << std::endl;
            while (hashes.find(h) != hashes.end()) {
                v = generateTest(hashes.size()+1, attempt++);
                h = hash_vector_of_strings(v);
            }

            print(v, hashes.size()+1);
            hashes.insert(h);
        }
    }

    return 0;
}
