#include <iostream>
#include <stack>
#include <vector>
#include <cassert>

using namespace std;

const int MAXN = 1000000;
long long TARGET_OR;

long long a[MAXN+1];
int end_or[MAXN];
int end_and[MAXN];

void calcOr(int n) {
    int l = 0;
    int r = -1;
    stack<long long> st;
    st.push(0);
    long long curr = 0;
    for (int i = 0; i < n; i++) {
        while (r < n && (st.top()|curr) != TARGET_OR) {
            curr |= a[++r];
        }
        if (st.size() == 1) {
            for (int j = r; j >= i; j--) {
                st.push(st.top()|a[j]);
            }
            curr = 0;
        }

        end_or[i] = r;
        st.pop();
    }
}

void calcAnd(int n) {
    int l = 0;
    int r = -1;
    stack<long long> st;
    st.push(TARGET_OR);
    long long curr = TARGET_OR;
    for (int i = 0; i < n; i++) {
        while (r < n && (st.top()&curr) != 0) {
            curr &= a[++r];
        }
        if (st.size() == 1) {
            for (int j = r; j >= i; j--) {
                st.push(st.top()&a[j]);
            }
            curr = TARGET_OR;
        }

        end_and[i] = r;
        st.pop();
    }
}

void validate(int n, int k, vector<long long>& v) {
    assert(1 <= n && n <= 1000000);
    assert(1 <= k && k <= 63);

    long long maxV = (1ULL<<k)-1;

    assert(n == v.size());
    for (int i = 0; i < n; i++) {
        assert(0 <= v[i] && v[i] <= maxV);
    }
}

long long oriand(int n, int k, vector<long long> v) {
    validate(n, k, v);

    TARGET_OR = (1ULL<<k)-1;

    for (int i = 0; i < n; i++) a[i] = v[i];

    calcOr(n);
    calcAnd(n);

    long long ans = 0;
    for (int i = 0; i < n; i++) {
        int m = end_or[i];
        int r = m+1 < n ? end_and[m+1] : n;
        ans += n-r;
    }

    return ans;
}
