#include <iostream>
#include <vector>

using namespace std;

const int MAXN = 1000000;
long long TARGET_OR;

long long a[MAXN+1];
int end_or[MAXN];
int end_and[MAXN];
long long stOr[MAXN][20];
long long stAnd[MAXN][20];
int maxPow[MAXN];

void buildSTs(int n) {
    for (int i = 0; (1 << i) < n; i++) {
        maxPow[1<<i] = i;
    }
    for (int i = 1; i <= n; i++) {
        if (maxPow[i] == 0) maxPow[i] = maxPow[i-1];
    }

    for (int i = 0; i < n; i++) {
        stOr[i][0] = a[i];
        stAnd[i][0] = a[i];
    }

    for (int j = 1; j < 20; j++) {
        for (int i = 0; i < n; i++) {
            if (i+(1<<j)-1 >= n) break;

            stOr[i][j] = stOr[i][j-1]|stOr[i+(1<<(j-1))][j-1];
            stAnd[i][j] = stAnd[i][j-1]&stAnd[i+(1<<(j-1))][j-1];
        }
    }
}

long long getOr(int l, int r) {
    if (l > r) return 0;
    int p = maxPow[r-l+1];
    return stOr[l][p]|stOr[r-(1<<p)+1][p];
}

long long getAnd(int l, int r) {
    if (l > r) return TARGET_OR;
    int p = maxPow[r-l+1];
    return stAnd[l][p]&stAnd[r-(1<<p)+1][p];
}

void calcOr(int n) {
    int l = 0;
    int r = -1;
    for (int i = 0; i < n; i++) {
        while (r < n && getOr(l, r) != TARGET_OR) {
            ++r;
        }
        end_or[i] = r;
        l++;
    }
}

void calcAnd(int n) {
    int l = 0;
    int r = -1;
    for (int i = 0; i < n; i++) {
        while (r < n && getAnd(l, r) != 0) {
            ++r;
        }
        end_and[i] = r;
        l++;
    }
}


long long oriand(int n, int k, vector<long long> v) {
    TARGET_OR = (1ULL<<k)-1;

    for (int i = 0; i < n; i++) a[i] = v[i];

    buildSTs(n);

    calcOr(n);
    calcAnd(n);

    long long ans = 0;
    for (int i = 0; i < n; i++) {
        int m = end_or[i];
        int r = m+1 < n ? end_and[m+1] : n;
        ans += n-r;
    }

    return ans;

    return 0;
}
