#include <iostream>
#include <vector>
using namespace std;

const int MAXN = 1000006;
const int LOGN = 20;
long long ONES;


int n, log2[MAXN];
long long sta[LOGN][MAXN], sto[LOGN][MAXN];
int wina[MAXN], wino[MAXN];

void Init(const vector<long long> &A)
{
    log2[0] = -1;
    for (int i = 1; i <= n; ++ i)
    {
        sto[0][i] = sta[0][i] = A[i - 1];
        log2[i] = log2[i / 2] + 1;

        //cout << i << ' ' << log2[i] << endl;
    }

    for (int k = 1; k <= log2[n]; ++ k)
    {
        for (int i = 1; i <= n; ++ i)
        {
            sta[k][i] = sta[k - 1][i] & sta[k - 1][i + (1 << (k - 1))];
            sto[k][i] = sto[k - 1][i] | sto[k - 1][i + (1 << (k - 1))];
        }
    }
}

inline long long querya(int l, int r)
{
    int k = log2[r - l + 1];
    return sta[k][l] & sta[k][r - (1 << k) + 1];
}

inline long long queryo(int l, int r)
{
    int k = log2[r - l + 1];
    return sto[k][l] | sto[k][r - (1 << k) + 1];
}

void Windows()
{
    int r = 0;
    for (int l = 1; l <= n; ++ l)
    {
        while ((r < l or querya (l, r) != 0) and r <= n)
        {
            r++;
        }
        wina[l] = r;
        //cout << wina[l] << ' ' ;
    }
    //cout  << endl;
    r = 0;
    for (int l = 1; l <= n; ++ l)
    {
        while ((r < l or queryo(l, r) != ONES) and r <= n)
        {
            r++;
        }
        wino[l] = r;
        //cout << wino[l] << ' ';
    }
    //cout << endl;
}

long long oriand(int N, int K, vector<long long> A)
{
    ONES = (1ULL << K) - 1;

    n = N;
    Init(A);
    Windows();

    long long ans = 0;
    for (int i = n; i >= 1; -- i)
    {
        if (wino[i] < n and wina[wino[i] + 1] <= n) ans += n + 1 - wina[wino[i] + 1];
    }

    return ans;
}
