#include <iostream>
#include <vector>

using namespace std;

const int MAXN = 1000000;
const long long TARGET_OR = (1ULL<<63)-1;

int end_or[MAXN];
int end_and[MAXN];

void calcOr(int n, vector<long long>& v) {
    int r = -1;
    long long curr = 0;
    for (int i = 0; i < n; i++) {
        while (r < n && curr != TARGET_OR) {
            curr |= v[++r];
        }
        end_or[i] = r;

        curr = 0;
        for (int j = i+1; j <= r; j++) curr |= v[j];
    }
}

void calcAnd(int n, vector<long long>& v) {
    int l = 0;
    int r = -1;
    long long curr = TARGET_OR;
    for (int i = 0; i < n; i++) {
        while (r < n && curr != 0) {
            curr &= v[++r];
        }
        end_and[i] = r;

        curr = TARGET_OR;
        for (int j = i+1; j <= r; j++) curr &= v[j];
    }
}

long long oriand(int n, vector<long long> v) {
    calcOr(n, v);
    calcAnd(n, v);

    //for (int i = 0; i < n; i++) cout << end_or[i] << " "; cout << endl;
    //for (int i = 0; i < n; i++) cout << end_and[i] << " "; cout << endl;

    long long ans = 0;
    for (int i = 0; i < n; i++) {
        int m = end_or[i];
        int r = m+1 < n ? end_and[m+1] : n;
        ans += n-r;
    }

    return ans;
}
