#include <iostream>
#include <vector>
#include <algorithm>
#include <random>
#include <map>

#include "mummy.h"

#define maxn 100005
#define X first
#define Y second
#define PB push_back

typedef long long ll;
typedef std::pair <int, int> pii;
typedef std::pair <ll, ll> pll;


const ll INF = 4e18;
const ll mod = 1e9 + 7;



std::vector <int> findPerm(int N)
{
    int n;
    n = N;

    std::vector <int> p;
    p.resize(n);
    for(int i = 0; i < n; i++)
        p[i] = i;

    std::random_shuffle(p.begin() , p.end());

    std::vector <bool> fixed(n, false);

    std::mt19937 rng(69420);
    std::uniform_int_distribution <int> d(0 , n - 1);

    std::vector <int> free;

    std::vector <std::map <int , bool> > used;

    used.resize(n);

    while(true)
    {
        int curr = numMatches(p);
        if(curr == n)
            break;

        for(int i = 0; i < n; i++)
            if(fixed[i] == false)
                free.PB(i);

        std::uniform_int_distribution <int> d(0 , (int)free.size() - 1);
        int l = d(rng);
        int r = d(rng);
        while(l == r && used[l][r] == false)
            r = d(rng);


        int pi = free[l];
        int pj = free[r];

        std::swap(p[pi] , p[pj]);
        used[p[pi]][p[pj]] = true;

        int curr2 = numMatches(p);
        if(abs(curr2 - curr) == 2)
        {
            fixed[pi] = true;
            fixed[pj] = true;
        }

        if(curr > curr2)
            std::swap(p[pi] , p[pj]);
    }


    return p;
}
