#include <bits/stdc++.h>

using namespace std;

#ifdef __LOCAL__
    #include "grader_cleanup.cpp"
#endif // __LOCAL__

const int MAXN = 305;
const int64_t INF = 1e18;

int N, maxBags;
int64_t cost[MAXN][MAXN];

void calculateCost(const vector <int64_t> &V, int64_t C)
{
    for (int64_t r = 1; r <= N; r++)
    {
        cost[r][r] = 2*r*C + r*V[r-1];
        for (int64_t l = r-1; l >= 1; l--)
        {
            cost[l][r] = cost[l+1][r] + (2*r-l)*V[l-1];
        }
    }
}

int64_t rec(const int K, int pos, int openning, int br)
{
    if (pos == N)
    {
        return cost[openning][pos];
    }

    int64_t ans = rec(K, pos+1, openning, br);
    if (br < K)
    {
        ans = min(ans, cost[openning][pos]+rec(K, pos+1, pos+1, br+1));
    }
    return ans;

}
long long solve(const vector <long long> &V, int K, long long C)
{
    N = V.size();
    calculateCost(V, C);

    int64_t ans = rec(K, 1, 1, 1);
    return ans;
}
