#include <iostream>
#include <vector>
using namespace std;
using ll = long long;
const ll maxN = 1e6 + 9, inf = 9e18;
template<typename T, ll mod>
struct ModArr {
    ModArr() {}
    ~ModArr() {}
    T& operator[](ll rhs) { return item[rhs % mod]; }
    const T& operator[](ll rhs) const { return item[rhs % mod]; }
    T item[mod];
};

ModArr<ll[maxN], 2> dp;
ll tileSub[maxN], tsPref[maxN], pref[maxN];
ll C;
ll getPr(ll* arr, ll i) { return (i < 0 ? 0 : arr[i]); }
ll getCost(ll l, ll r) {
    r--;
    return 2 * (r + 1) * (pref[r] - getPr(pref, l - 1)) - (tsPref[r] - getPr(tsPref, l - 1))
            + 2 * (r + 1) * C;
}

void dc(ll l, ll r, ll optL, ll optR, ll k) {
    if (l > r) { return; }
    ll mid = (l + r) / 2;
    ll optMid = 0;
    dp[k][mid] = inf;
    for (ll i = optL; i <= min(mid - 1, optR); i++) {
        ll val = dp[k - 1][i] + getCost(i, mid);
        if (val < dp[k][mid]) {
            optMid = i;
            dp[k][mid] = val;
        }
    }
    dc(l, mid - 1, optL, optMid, k);
    dc(mid + 1, r, optMid, optR, k);
}

ll solve(const vector<ll> &V, int k, ll C_) {
    ll n = V.size(); C = C_;
    for (ll i = 0; i < n; i++) {
        pref[i] = (i == 0 ? 0 : pref[i - 1]) + V[i];
        tileSub[i] = V[i] * (i + 1);
        tsPref[i] = (i == 0 ? 0 : tsPref[i - 1]) + tileSub[i];
        if (i != 0) { dp[0][i] = inf; }
    }

    for (ll i = 1; i <= k; i++) { dc(1, n, 0, n, i); }
    return dp[k][n];
}
