#include <iostream>
#include <vector>
using namespace std;
using ll = long long;
const ll maxN = 300, inf = 1e18;
ll dp[maxN][maxN];
ll tileSub[maxN], tsPref[maxN], pref[maxN];
ll getPr(ll* arr, ll i) { return (i < 0 ? 0 : arr[i]); }
ll getCost(ll l, ll r, ll C) {
    return 2 * (r + 1) * (pref[r] - getPr(pref, l - 1)) - (tsPref[r] - getPr(tsPref, l - 1))
            + 2 * (r + 1) * C;
}

ll solve(const vector<ll> &V, int k, ll C) {
    int n = V.size();
    for (int i = 0; i < n; i++) {
        pref[i] = (i == 0 ? 0 : pref[i - 1]) + V[i];
        tileSub[i] = V[i] * (i + 1);
        tsPref[i] = (i == 0 ? 0 : tsPref[i - 1]) + tileSub[i];
        if (i != 0) { dp[0][i] = inf; }
    }

    for (int i = 1; i <= k; i++) {
        for (int j = 1; j <= n; j++) {
            dp[i][j] = inf;
            for (int q = 0; q < j; q++) {
                dp[i][j] = min(dp[i][j], dp[i - 1][q] + getCost(q, j - 1, C));
            }
        }
    }
    return dp[k][n];
}
