#include <iostream>
#include <vector>
#include <algorithm>
#include <cstdlib>
#include <ctime>
#include "mummy.h"


const int MAX_N = 44;
float table[MAX_N][MAX_N] = { 0 };
std::vector <int> seq;

std::vector <int> randPerm(int n) {
    std::vector <int> r;
    for (int i = 0; i < n; i++) {
        r.push_back(i);
    }

    for (int i = 0; i < 200; i++) {
        std::swap(r[rand() % n], r[rand() % n]);
    }

    return r;
}

void nullTable() {
    for (int i = 0; i < MAX_N; i++) for (int j = 0; j < MAX_N; j++) table[i][j] = 0;
}

void testRandPerm() {
    std::vector <int> r = randPerm(MAX_N);
    int num = numMatches(r);
    for (int i = 0; i < MAX_N; i++) table[i][r[i]] += float(num)/MAX_N;
}

std::vector <int> getCurrBest() {
    std::vector <int> res;
    for (int x = 0; x < MAX_N; x++) {
        int max_ind = 0;
        for (int y = 0; y < MAX_N; y++) {
            if (table[x][y] > table[x][max_ind]) {
                max_ind = y;
            }
        }
        res.push_back(max_ind);
    }
    return res;
}

std::vector <int> findPerm(int N) {
    nullTable();
    for (int i = 0; i < 3700; i++) {
        testRandPerm();
    }

    return getCurrBest();
}
