#include <vector>
#include <stack>
#include "plans.h"
using namespace std;

const int MAXN = 10 + 10;
vector <int> edges[MAXN], reverse_edges[MAXN];
bool visited[MAXN];
int component[MAXN];
stack <int> topological;

void dfs(int u) {
    if (visited[u]) return;
    visited[u] = 1;

    for (int x : edges[u]) {
        dfs(x);
    }

    topological.push(u);
}

void component_dfs(int u, int current) {
    if (component[u]) return;
    component[u] = current;

    for (int x : reverse_edges[u]) {
        component_dfs(x, current);
    }
}

int count_plans(int n, int k) {
    int ans = 0;

    vector <pair <int, int>> possible_edges;

    for (int i = 1; i <= n; i++) {
        for (int j = 1; j <= n; j++) {
            if (i != j) possible_edges.push_back({i, j});
        }
    }

    int m = possible_edges.size();

    for (int mask = 0; mask < (1 << m); mask++) {
        for (int i = 0; i < m; i++) {
            auto [u, v] = possible_edges[i];
            if (mask & (1 << i)) {
                edges[u].push_back(v);
                reverse_edges[v].push_back(u);
            }
        }

        for (int i = 1; i <= n; i++) {
            dfs(i);
        }

        int components = 0;

        while (topological.size()) {
            int u = topological.top();
            topological.pop();

            if (component[u]) continue;
            component_dfs(u, ++components);
        }

        ans += (components == k);

        for (int i = 1; i <= n; i++) {
            edges[i].clear();
            reverse_edges[i].clear();
            visited[i] = component[i] = 0;
        }
    }

    return ans;
}
