#include <bits/stdc++.h>
#include "mummy.h"
using namespace std;

mt19937 rng(time(0));

vector <pair <int, int>> get_matching(vector <int> remaining_indices) {
    shuffle(remaining_indices.begin(), remaining_indices.end(), rng);
    vector <pair <int, int>> ans;

    for (int i = 0; i + 1 < remaining_indices.size(); i += 2) {
        ans.push_back({remaining_indices[i], remaining_indices[i + 1]});
    }

    return ans;
}

vector <int> apply_matching(vector <int> ans, vector <pair <int, int>> matching) {
    for (auto [u, v] : matching) {
        swap(ans[u], ans[v]);
    }

    return ans;
}

pair <vector <pair <int, int>>, vector <pair <int, int>>> divide(vector <pair <int, int>> matching) {
    int m = (matching.size() - 1) / 2;
    vector <pair <int, int>> l, r;

    for (int i = 0; i < matching.size(); i++) {
        if (i <= m) l.push_back(matching[i]);
        else r.push_back(matching[i]);
    }

    return {l, r};
}

pair <int, int> dq(vector <int> ans, int last, vector <pair <int, int>> matching) {
    //cout << "Dividing..." << endl;
    if (matching.size() == 1) return matching.front();
    auto [l, r] = divide(matching);

    assert(!l.empty());
    assert(!r.empty());

    if (numMatches(apply_matching(ans, l)) > last) return dq(ans, last, l);
    return dq(ans, last, r);
}

vector <int> findPerm(int n) {
    vector <int> ans(n);
    iota(ans.begin(), ans.end(), 0);

    int last = numMatches(ans);

    vector <int> remaining_indices(n - 1);
    iota(remaining_indices.begin(), remaining_indices.end(), 1);

    for (int i = 0; i < 1; i++) {
        for (int j = i + 1; j < n; j++) {
            vector <int> temp = ans;
            swap(temp[i], temp[j]);

            int current = numMatches(temp);

            if (current > last) {
                ans = temp;
                last = current;
            }
        }
    }

    while (remaining_indices.size() > 10) {
        if (last == n) break;
        if ((last - (n - remaining_indices.size())) * 3 >= remaining_indices.size()) {
            vector <int> new_remaining;

            for (int x : remaining_indices) {
                vector <int> temp = ans;
                swap(temp[0], temp[x]);

                if (numMatches(temp) != last - 2) {
                    new_remaining.push_back(x);
                }
            }

            remaining_indices = new_remaining;
            continue;
        }


        vector <pair <int, int>> matching;
        vector <int> temp;
        int current;

        while (1) {
            matching = get_matching(remaining_indices);
            temp = apply_matching(ans, matching);

            current = numMatches(temp);
            if (current > last) break;

            last = current;
            ans = temp;
        }

        pair <int, int> match = dq(ans, last, matching);
        temp = apply_matching(ans, {match});
        current = numMatches(temp);

        ans = temp;
        last = current;

        if (current == last + 2) {
            remaining_indices.erase(find(remaining_indices.begin(), remaining_indices.end(), match.first));
            remaining_indices.erase(find(remaining_indices.begin(), remaining_indices.end(), match.second));
            continue;
        }

        vector <int> temp2 = apply_matching(temp, {{0, match.first}});
        int current2 = numMatches(temp2);

        if (current2 == current - 2) {
            remaining_indices.erase(find(remaining_indices.begin(), remaining_indices.end(), match.first));
        } else {
            remaining_indices.erase(find(remaining_indices.begin(), remaining_indices.end(), match.second));
        }
    }

    sort(remaining_indices.begin(), remaining_indices.end());

    for (int x : remaining_indices) {
        for (int y : remaining_indices) {
            if (x >= y) continue;
            vector <int> temp = ans;
            swap(temp[x], temp[y]);
            int current = numMatches(temp);

            if (current > last) {
                last = current;
                ans = temp;
            }
        }
    }

    return ans;
}
