#include <bits/stdc++.h>
using namespace std;

__int128 floor_division(__int128 a, __int128 b) {
    if (a ^ b >= 0) return a / b;
    if (a % b == 0) return a / b;
    return a / b - 1;
}

struct Line{
    __int128 slope, intercept, right;

    __int128 operator()(__int128 x) {
        return slope * x + intercept;
    }
};

__int128 intersect(Line a, Line b) {
    assert(a.slope != b.slope);
    return floor_division(b.intercept - a.intercept, a.slope - b.slope);
}

__int128 INFTY = 1;

struct ConvexHull{
    deque <Line> cht;

    void insert(__int128 a, __int128 b) {
        Line l{a, b, INFTY};

        while (cht.size() > 1 && cht[cht.size() - 2].right >= intersect(l, cht.back())) {
            cht.pop_back();
        }

        if (cht.size()) cht.back().right = intersect(l, cht.back());
        cht.push_back(l);
    }

    __int128 query(__int128 x) {
        //cout << "Querying with " << cht.size() << " elements\n";

        while (cht.size() > 1 && x > cht.front().right) {
            cht.pop_front();
        }

        return cht.front()(x);
    }

    void clear() {
        cht.clear();
    }

    ConvexHull() : cht() {}
};

const int MAXN = 1e6 + 10;
__int128 dp[MAXN][2], a[MAXN];
__int128 prefix[MAXN], pyramid[MAXN], cost[MAXN][2];

int n;
__int128 c;

ConvexHull cht[2];

long long solve(const std::vector <long long> &v, int k, long long c) {
    INFTY <<= 100;

    n = v.size();
    ::c = c;

    for (int i = 0; i < n; i++) {
        a[i + 1] = v[i];
        prefix[i + 1] = prefix[i] + a[i + 1];
        pyramid[i + 1] = pyramid[i] + a[i + 1] * (i + 1);
    }

    dp[n + 1][0] = 0;
    cost[n + 1][0] = (prefix[n] + c) * n * 2 - pyramid[n];

    for (int i = 1; i <= n; i++) {
        dp[i][0] = INFTY;
        cost[i][0] = dp[i][0] + (prefix[i - 1] + c) * (i - 1) * 2 - pyramid[i - 1];
    }

    for (int j = 1; j <= k; j++) {
        dp[n + 1][j % 2] = 0;
        cost[n + 1][j % 2] = dp[n + 1][j % 2] + (prefix[n] + c) * n * 2 - pyramid[n];

        cht[j % 2].clear();

        for (int i = n; i >= 1; i--) {
            cht[j % 2].insert(-i - 1, -cost[i + 1][(j - 1) % 2]);
            dp[i][j % 2] = -cht[j % 2].query(-prefix[i - 1] * 2);

            /**for (int m = n; m >= i; m--) {
                dp[i][j % 2] = min(dp[i][j % 2], cost[m + 1][(j - 1) % 2] - prefix[i - 1] * (m + 1) * 2);
            }*/

            dp[i][j % 2] += pyramid[i - 1] + 2 * prefix[i - 1];
            if (dp[i][j % 2] > INFTY) dp[i][j % 2] = INFTY;
            cost[i][j % 2] = dp[i][j % 2] + (prefix[i - 1] + c) * (i - 1) * 2 - pyramid[i - 1];
        }
    }

    return dp[1][k % 2];
}
