#include <bits/stdc++.h>
using namespace std;

long long floor_division(long long a, long long b) {
    if (a ^ b >= 0) return a / b;
    if (a % b == 0) return a / b;
    return a / b - 1;
}

struct Line{
    long long slope, intercept, right;

    long long operator()(long long x) {
        return slope * x + intercept;
    }
};

long long intersect(Line a, Line b) {
    assert(a.slope != b.slope);
    return floor_division(b.intercept - a.intercept, a.slope - b.slope);
}

const long long INFTY = 6e18;

struct ConvexHull{
    deque <Line> cht;

    void insert(long long a, long long b) {
        Line l{a, b, INFTY};

        while (cht.size() > 1 && cht[cht.size() - 2].right >= intersect(l, cht.back())) {
            cht.pop_back();
        }

        if (cht.size()) cht.back().right = intersect(l, cht.back());
        cht.push_back(l);
    }

    long long query(long long x) {
        //cout << "Querying with " << cht.size() << " elements\n";

        while (cht.size() > 1 && x > cht.front().right) {
            cht.pop_front();
        }

        return cht.front()(x);
    }

    void clear() {
        cht.clear();
    }

    ConvexHull() : cht() {}
};

const int MAXN = 1e6 + 10;
long long dp[MAXN][2], a[MAXN];
long long prefix[MAXN], pyramid[MAXN], cost[MAXN][2];

int n;
long long c;

ConvexHull cht[2];

long long solve(const std::vector <long long> &v, int k, long long c) {
    n = v.size();
    ::c = c;

    for (int i = 0; i < n; i++) {
        a[i + 1] = v[i];
        prefix[i + 1] = prefix[i] + a[i + 1];
        pyramid[i + 1] = pyramid[i] + a[i + 1] * (i + 1);
    }

    dp[n + 1][0] = 0;
    cost[n + 1][0] = (prefix[n] + c) * n * 2 - pyramid[n];

    for (int i = 1; i <= n; i++) {
        dp[i][0] = INFTY;
        cost[i][0] = dp[i][0] + (prefix[i - 1] + c) * (i - 1) * 2 - pyramid[i - 1];
    }

    for (int j = 1; j <= k; j++) {
        dp[n + 1][j % 2] = 0;
        cost[n + 1][j % 2] = dp[n + 1][j % 2] + (prefix[n] + c) * n * 2 - pyramid[n];

        cht[j % 2].clear();

        for (int i = n; i >= 1; i--) {
            cht[j % 2].insert(-i - 1, -cost[i + 1][(j - 1) % 2]);
            dp[i][j % 2] = -cht[j % 2].query(-prefix[i - 1] * 2);

            /**for (int m = n; m >= i; m--) {
                dp[i][j % 2] = min(dp[i][j % 2], cost[m + 1][(j - 1) % 2] - prefix[i - 1] * (m + 1) * 2);
            }*/

            dp[i][j % 2] += pyramid[i - 1] + 2 * prefix[i - 1];
            if (dp[i][j % 2] > INFTY) dp[i][j % 2] = INFTY;
            cost[i][j % 2] = dp[i][j % 2] + (prefix[i - 1] + c) * (i - 1) * 2 - pyramid[i - 1];
        }
    }

    return dp[1][k % 2];
}
