#include <bits/stdc++.h>

using namespace std;

const int maxn = 1e6 + 5;
const long long inf = (1LL << 62);

int n, k;
long long c;

long long a[maxn];
long long pref1[maxn];
long long pref2[maxn];

long long calc(int from, int to)
{
    int len = to - from + 1;
    return c * (1LL * to * 2) + pref2[to] - pref2[from - 1] - (1LL * (n - to + 1)) * (pref1[to] - pref1[from - 1])
          + (pref1[to] - pref1[from - 1]) * (1LL * to);
}

struct Line
{
    long long a, b;
    int idx;

    long long calc(long long x)
    {
        return a * x + b;
    }
};

pair<long long, int> dp[maxn];


struct ConvexHullTrickMIN
{
    vector<pair<double, Line>> envelope;

    void reset()
    {
        envelope.clear();
    }

    double intersect(const Line& l1, const Line& l2)
    {
        return (1.0 * (l2.b - l1.b)) / (1.0 * (l1.a - l2.a));
    }

    bool skip = false;

    bool check(const Line& newLine, const Line& prv, const Line& prv2)
    {
        if (intersect(newLine, prv2) == intersect(prv, prv2))
        {
            skip = true;
            return dp[newLine.idx].second < dp[prv.idx].second;
        }
        return intersect(newLine, prv2) <= intersect(prv, prv2);
    }

    void add(Line l)
    {
        skip = false;
        while (envelope.size() > 1 && check(l, envelope.back().second, envelope[envelope.size() - 2].second) == true)
        {
            envelope.pop_back();
        }

        if (skip == true) return;

        if (envelope.empty())
        {
            envelope.push_back({-inf, l});
        }
        else
        {
            envelope.push_back({intersect(l, envelope.back().second), l});
        }
    }

    Line query(long long x)
    {
        int l = 0, r = envelope.size() - 1;

        while (l <= r)
        {
            int mid = (l + r) / 2;

            if (envelope[mid].first <= x)
            {
                l = mid + 1;
            }
            else
            {
                r = mid - 1;
            }
        }

        return envelope[r].second;
    }
};

ConvexHullTrickMIN cht;


void alien(long long lambda)
{
    dp[0] = {0, 0};
    for (int i = 1; i <= n; ++i) dp[i] = {inf, 0};

    cht.reset();

    /*cout << cht.envelope.size() << endl;
    for (int i = 1; i <= n; ++i)
    {
        cout << dp[i].first << " " << dp[i].second << endl;
    }*/

    for (int i = 1; i <= n; ++i)
    {
        dp[i] = min(dp[i], {lambda + calc(1, i), 1});
        if (i > 1)
        {
            Line l = cht.query(2 * i - n - 1);
            dp[i] = min(dp[i], {lambda + l.calc(2 * i - n - 1) + 2 * c * (1LL * i) + pref1[i] * (1LL * (2 * i - n - 1)) + pref2[i], 1 + dp[l.idx].second});
        }
        cht.add({-pref1[i], -pref2[i] + dp[i].first, i});
    }
}

long long solve(const std::vector <long long> &V, int K, long long C)
{
    n = V.size(); k = K; c = C;
    for (int i = 0; i < n; ++i)
    {
        a[i + 1] = V[i];
    }

    for (int i = 1; i <= n; ++i)
    {
        pref1[i] = pref1[i - 1] + a[i];
        pref2[i] = pref2[i - 1] + (1LL * (n - i + 1)) * a[i];
    }

    alien(0);
    //cout << "BEG " << dp[n].first << " " << dp[n].second << endl;
    if (dp[n].second <= k)
    {
        return dp[n].first;
    }

    //alien(5000000);
    //alien(0);
    //cout << "BEG2 " << dp[n].first << " " << dp[n].second << endl;

    long long bsl = -10000000000000;
    long long bsr = 10000000000000;
    long long ans = 0;

    while (bsl <= bsr)
    {
        //cout << bsl << " " << bsr << " " << bsl + bsr << " :: " << (bsl + bsr) / 2 << endl;
        long long bsmid = (bsl + bsr) / 2;
        alien(bsmid);

        //cout << bsmid << " " << dp[n].first << " " << dp[n].second << " :: " << dp[n].first - k * bsmid << endl;

        if (dp[n].second > k)
        {
            bsl = bsmid + 1;
        }
        else
        {
            ans = bsmid;
            bsr = bsmid - 1;
        }
    }

    alien(bsl);
    return dp[n].first - (1LL * k) * bsl;
}
