#include <bits/stdc++.h>

using namespace std;

const int maxn = 1e6 + 5;
const long long inf = (1LL << 62);

int n, k;
long long c;

long long a[maxn];
long long pref1[maxn];
long long pref2[maxn];

vector<vector<long long>> dp;

long long calc(int from, int to)
{
    int len = to - from + 1;
    return c * (1LL * to * 2) + pref2[to] - pref2[from - 1] - (1LL * (n - to + 1)) * (pref1[to] - pref1[from - 1])
          + (pref1[to] - pref1[from - 1]) * (1LL * to);
}

struct Line
{
    long long a, b;

    long long calc(long long x)
    {
        return a * x + b;
    }
};

struct ConvexHullTrickMIN
{
    vector<pair<double, Line>> envelope;

    void reset()
    {
        envelope.empty();
    }

    double intersect(const Line& l1, const Line& l2)
    {
        return (1.0 * (l2.b - l1.b)) / (1.0 * (l1.a - l2.a));
    }

    bool check(const Line& newLine, const Line& prv, const Line& prv2)
    {
        return intersect(newLine, prv2) <= intersect(prv, prv2);
    }

    void add(Line l)
    {
        while (envelope.size() > 1 && check(l, envelope.back().second, envelope[envelope.size() - 2].second) == true)
        {
            envelope.pop_back();
        }

        if (envelope.empty())
        {
            envelope.push_back({-inf, l});
        }
        else
        {
            envelope.push_back({intersect(l, envelope.back().second), l});
        }
    }

    long long query(long long x)
    {
        int l = 0, r = envelope.size() - 1;

        while (l <= r)
        {
            int mid = (l + r) / 2;

            if (envelope[mid].first <= x)
            {
                l = mid + 1;
            }
            else
            {
                r = mid - 1;
            }
        }

        return envelope[r].second.calc(x);
    }
};

ConvexHullTrickMIN cht[905];

long long solve(const std::vector <long long> &V, int K, long long C)
{
    n = V.size(); k = K; c = C;
    for (int i = 0; i < n; ++i)
    {
        a[i + 1] = V[i];
    }

    for (int i = 1; i <= n; ++i)
    {
        pref1[i] = pref1[i - 1] + a[i];
        pref2[i] = pref2[i - 1] + (1LL * (n - i + 1)) * a[i];
    }

    if (k == 1)
    {
        return calc(1, n);
    }

    dp.resize(n + 2);
    for (int i = 0; i <= n; ++i)
    {
        dp[i].resize(k + 2);
        if (i == 0)
        {
            for (int j = 0; j <= k; ++j) dp[i][j] = 0;
            continue;
        }

        for (int j = 0; j <= k; ++j)
        {
            dp[i][j] = inf;
        }
    }

    for (int i = 1; i <= k; ++i)
    {
        cht[i].reset();
    }

    for (int pos = 1; pos <= n; ++pos)
    {
        dp[pos][1] = calc(1, pos);

        for (int bags = 2; bags <= min(pos, k); ++bags)
        {
            dp[pos][bags] = cht[bags - 1].query(2 * pos - n - 1) + 2 * c * (1LL * pos) + pref1[pos] * (1LL * (2 * pos - n - 1)) + pref2[pos];
        }

        for (int bags = 1; bags <= min(pos, k); ++bags)
        {
            //cout << "pos: " << pos << " bags: " << bags << " -> " << dp[pos][bags] << endl;
            cht[bags].add({-pref1[pos], -pref2[pos] + dp[pos][bags]});
        }
    }

    long long ans = dp[n][1];
    for (int i = 2; i <= k; ++i) ans = min(ans, dp[n][i]);
    return ans;
}
