/* the checker has three arguments:
    - first - name of the input file
    - second - name of the correct output file
    - third - name of the contestant output file */
#include<iostream>
#include<fstream>
#include<vector>
using namespace std;
void output_message (double points, string message) {
    cout << points << endl ;
    cerr << message << endl ;
    exit(0);
}
const long long int mod=666072103,base=18448403;
void calculate_hash (long long int& hash1, long long int value) {
    hash1*=base; hash1+=value;
    hash1%=mod;
}
int main (int argc, char** argv) {
    ifstream inp,ans,out;
    if (argc<4) output_message(0,"The checker needs input file, correct output and contestant output!");
    inp.open(argv[1]);
    if (inp.is_open()==false) output_message(0,"Could not open input file!");
    ans.open(argv[2]);
    if (ans.is_open()==false) output_message(0,"Could not open correct output file!");
    out.open(argv[3]);
    if (out.is_open()==false) output_message(0,"Could not open contestant output file!");

    int hash2;
    if (!(out >> hash2)) output_message(0,"Violation of the protocol for communication!");
    int n,k;
    long long int c;
    inp >> n >> k >> c ;
    long long int hash1=0;
    calculate_hash(hash1,n);
    calculate_hash(hash1,k);
    calculate_hash(hash1,c);
    for (int i=0; i<n; i++) {
        long long int num;
        inp >> num ;
        calculate_hash(hash1,num);
    }
    if (hash1!=hash2) output_message(0,"Violation of the protocol for communication!");

    long long int ans2;
    if (!(out >> ans2)) output_message(0,"Violation of the protocol for communication!");
    long long int ans1;
    ans >> ans1 ;
    if (ans1!=ans2) output_message(0,"Wrong answer!");

    output_message(1,"OK!");
    return 0;
}
