#include <algorithm>
#include <iostream>
#include <numeric>
#include <cassert>
#include <vector>

typedef long long llong;
const int MAXN = 20000 + 10;
const int MAXK = 400 + 10;
const llong INF = 5e18;

int n, k;
llong v[MAXN], c;
llong dp[MAXN][MAXK];
llong prefix[MAXN];

inline llong cost(int l, int r)
{
    return (prefix[r] - prefix[l - 1] + c) * r;
}

llong solve(const std::vector <llong> &V, int K, llong C)
{
    n = V.size();
    k = K;
    c = C;

    llong answer = 0;
    for (int i = 1 ; i <= n ; ++i)
    {
        v[i] = V[i - 1];
        answer -= v[i] * i;
    }

    for (int i = 1 ; i <= n ; ++i)
    {
        v[i] *= 2;
    }

    c *= 2;
    for (int i = 1 ; i <= n ; ++i)
    {
        prefix[i] = prefix[i - 1] + v[i];
    }

    dp[0][0] = 0;
    for (int i = 1 ; i <= k ; ++i)
    {
        dp[0][i] = INF;
    }

    for (int idx = 1 ; idx <= n ; ++idx)
    {
        dp[idx][0] = INF;
        for (int split = 1 ; split <= k ; ++split)
        {
            dp[idx][split] = INF;
            for (int l = 1 ; l <= idx ; ++l)
            {
                dp[idx][split] = std::min(dp[idx][split], cost(l, idx) + dp[l - 1][split - 1]);
            }
        }
    }

    llong min = dp[n][1];
    for (int i = 1 ; i <= k ; ++i)
    {
        min = std::min(min, dp[n][i]);
    }

    answer += min;
    return answer;
}