#include <algorithm>
#include <iostream>
#include <numeric>
#include <cassert>
#include <vector>
#include <deque>

typedef long long llong;
const int MAXN = 1e6 + 10;
const llong INF = 2e18;

int n, k;
llong v[MAXN], c;
llong prefix[MAXN];

struct CHT
{
    struct Line
    {
        llong a, b;
        llong start;
        int countIntervals;

        inline std::pair <llong,int> at(llong x)
        {
            return {a * x + b, countIntervals};
        }
    };

    inline llong intersect(Line oldLine, Line newLine)
    {
        llong up = oldLine.b - newLine.b;
        llong down = newLine.a - oldLine.a;
        llong div = up / down;
        llong rem = up % down;
         
        if (rem != 0)
        {
            return std::min(1LL * n + 1, div + 1);
        }

        if (oldLine.countIntervals > newLine.countIntervals) return std::min(1LL * n, div);
        else return std::min(1LL * n + 1, div + 1);
    }

    std::deque <Line> cht;
    void push(Line l)
    {
        while (cht.size() && cht.back().at(cht.back().start) <= l.at(cht.back().start))
        {
            cht.pop_back();
        }

        if (cht.empty()) cht.push_back(l);
        else cht.push_back({l.a, l.b, intersect(cht.back(), l), l.countIntervals});
    }

    std::pair <llong,int> query(int r)
    {
        while (cht.size() >= 2 && cht[1].start <= r)
        {
            cht.pop_front();
        }

        return cht[0].at(r);
    }
};

CHT cht;
inline llong cost(int l, int r)
{
    return (prefix[r] - prefix[l - 1] + c) * r;
}

std::pair <llong,int> dp[MAXN];
std::pair <llong,int> calculate(llong penalty)
{
    cht.cht.clear();
    cht.push({0, 0, 0, 0});
    for (int idx = 1 ; idx <= n ; ++idx)
    {
        auto [res, cnt] = cht.query(idx);
        dp[idx] = {idx * (c + prefix[idx]) - res + penalty, cnt + 1};
        cht.push({prefix[idx], -dp[idx].first, 0, dp[idx].second});
    }

    return dp[n];
}

llong solve(const std::vector <llong> &V, int K, llong C)
{
    n = V.size();
    k = K;
    c = C;

    llong answer = 0;
    for (int i = 1 ; i <= n ; ++i)
    {
        v[i] = V[i - 1];
        answer -= v[i] * i;
    }

    for (int i = 1 ; i <= n ; ++i)
    {
        v[i] *= 2;
    }

    c *= 2;
    for (int i = 1 ; i <= n ; ++i)
    {
        prefix[i] = prefix[i - 1] + v[i];
    }

    auto res = calculate(0);
    if (res.second <= k)
    {
        return res.first + answer;
    }
    
    llong l = 0, r = INF, mid;
    while (l < r - 1)
    {
        mid = l + r >> 1;
        if (calculate(mid).second >= k) l = mid;
        else r = mid;
    }
    
    auto [resL, cntL] = calculate(l);
    resL -= cntL * l;
    if (cntL == k)
    {
        return resL + answer;
    }
    
    auto [resR, cntR] = calculate(r);
    resR -= cntR * r;
    answer += resL + (__int128)((resR - resL) * (   cntL - k)) / (cntL - cntR);

    return answer;
}