#include <algorithm>
#include <iostream>
#include <numeric>
#include <cassert>
#include <vector>
#include <deque>

typedef long long llong;
const int MAXN = 1e6 + 10;
const llong INF = 5e18;

int n, k;
llong v[MAXN], c;
llong dp[2][MAXN];
llong prefix[MAXN];

struct CHT
{
    struct Line
    {
        llong a, b;
        llong start;

        inline llong at(llong x)
        {
            return a * x + b;
        }
    };

    inline llong intersect(Line oldLine, Line newLine)
    {
        llong up = oldLine.b - newLine.b;
        llong down = newLine.a - oldLine.a;
        return up / down + (up % down != 0);
    }

    std::vector <Line> cht;
    void push(Line l)
    {
        while (cht.size() && cht.back().at(cht.back().start) <= l.at(cht.back().start))
        {
            cht.pop_back();
        }

        if (cht.empty()) cht.push_back(l);
        else cht.push_back({l.a, l.b, intersect(cht.back(), l)});
    }

    llong query(int idx)
    {
        int l = 0, r = cht.size(), mid;
        while (l < r - 1)
        {
            mid = l + r >> 1;
            if (cht[mid].start <= idx) l = mid;
            else r = mid;
        }
    
        return cht[l].at(idx);
    }
};

CHT cht;
llong solve(const std::vector <llong> &V, int K, llong C)
{
    n = V.size();
    k = K;
    c = C;

    llong answer = 0;
    for (int i = 1 ; i <= n ; ++i)
    {
        v[i] = V[i - 1];
        answer -= v[i] * i;
    }

    for (int i = 1 ; i <= n ; ++i)
    {
        v[i] *= 2;
    }

    c *= 2;
    for (int i = 1 ; i <= n ; ++i)
    {
        prefix[i] = prefix[i - 1] + v[i];
    }

    dp[0][0] = 0;
    for (int i = 1 ; i <= n ; ++i)
    {
        dp[0][i] = INF;
    }

    llong min = INF;
    for (int split = 1 ; split <= k ; ++split)
    {
        cht.cht.clear();
        cht.push({0, 0, 0});
        for (int idx = 1 ; idx <= n ; ++idx)
        {
            dp[split & 1][idx] = idx * (c + prefix[idx]) - cht.query(idx);
            cht.push({prefix[idx], -dp[(split & 1) ^ 1][idx], 0});
        }
    
        min = std::min(min, dp[split & 1][n]);
    }
    
    answer += min;
    return answer;
}