#include <algorithm>
#include <iostream>
#include <numeric>
#include <cassert>
#include <vector>

typedef long long llong;
const int MAXN = 1e6 + 10;
const llong INF = 5e18;

int n, k;
llong v[MAXN], c;
llong prefix[MAXN];

inline llong cost(int l, int r)
{
    return (prefix[r] - prefix[l - 1] + c) * r;
}

llong solve(const std::vector <llong> &V, int K, llong C)
{
    n = V.size();
    k = K;
    c = C;

    llong answer = 0;
    for (int i = 1 ; i <= n ; ++i)
    {
        v[i] = V[i - 1];
        answer -= v[i] * i;
    }

    for (int i = 1 ; i <= n ; ++i)
    {
        v[i] *= 2;
    }

    c *= 2;
    for (int i = 1 ; i <= n ; ++i)
    {
        prefix[i] = prefix[i - 1] + v[i];
    }

    return cost(1, n) + answer;
}