#include <algorithm>
#include <iostream>
#include <numeric>
#include <cassert>
#include <vector>

typedef long long llong;
const int MAXN = 1e6 + 10;
const llong INF = 5e18;

int n, k;
llong v[MAXN], c;
llong prefix[MAXN];

inline llong cost(int l, int r)
{
    return (prefix[r] - prefix[l - 1] + c) * r;
}

llong solve(const std::vector <llong> &V, int K, llong C)
{
    n = V.size();
    k = K;
    c = C;

    llong answer = 0;
    for (int i = 1 ; i <= n ; ++i)
    {
        v[i] = V[i - 1];
        answer -= v[i] * i;
    }

    for (int i = 1 ; i <= n ; ++i)
    {
        v[i] *= 2;
    }

    c *= 2;
    for (int i = 1 ; i <= n ; ++i)
    {
        prefix[i] = prefix[i - 1] + v[i];
    }
    
    llong min = INF;
    for (int mask = 0 ; mask < (1 << n - 1) ; ++mask)
    {
        if (__builtin_popcount(mask) >= k)
        {
            continue;
        }

        int lastStart = 1;
        llong res = 0;
        for (int i = 0 ; i < n ; ++i)
        {
            if (i == n - 1 || mask & (1 << i))
            {
                res += cost(lastStart, i + 1);
                lastStart = i + 2;
            }
        }

        min = std::min(min, res);
    }

    answer += min;
    return answer;
}